/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db;

import java.util.Collection;
import java.util.List;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.NoHistoryException;
import org.simantics.db.service.UndoRedoSupport;

public interface UndoContext {
    /**
     * Called when operation has been committed successfully.
     * 
     * @param operation
     */
    void commitOk(Operation operation) throws DatabaseException;
    /**
     * 
     * @return the last successfully committed operation.
     */
    Operation getLast() throws DatabaseException;

    /**
     * 
     * @return the operation list.
     */
    Collection<Operation> getAll() throws DatabaseException;
    
    /**
     * 
     * @return the redo operation list.
     */
    Collection<Operation> getRedoList() throws DatabaseException ;

    /**
     * Revert the effects of last successfully committed operation in this context.
     * 
     * @param support
     * @return Number of change sets reverted. Zero if operation is not supported.
     * @throws NoHistoryException if there is no undo history left in this context
     * @throws DatabaseException
     */
    List<Operation> undo(UndoRedoSupport support, int count) throws NoHistoryException, DatabaseException;
    /**
     * Revert the effects of last successfully committed undo operation in this context.
     * 
     * @param support
     * @throws NoHistoryException if there is no redo history left in this context
     * @throws DatabaseException
     */
    List<Operation> redo(UndoRedoSupport support, int count) throws NoHistoryException, DatabaseException;

    /**
     * Remove all undo information. 
     */
    void clear();
}
