/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.server.internal;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.simantics.db.server.ProCoreException;
import org.simantics.db.server.internal.AbstractMethod;
import org.simantics.db.server.internal.Connection;
import org.simantics.db.server.internal.DefaultHandler;
import org.simantics.db.server.internal.ErrorHandler;
import org.simantics.db.server.internal.EventHandler;
import org.simantics.db.server.internal.ExceptionHandler;
import org.simantics.db.server.internal.MethodHandler;
import org.simantics.db.server.internal.Packet;
import org.simantics.db.server.protocol.AbstractFunction;
import org.simantics.db.server.protocol.DataBuffer;

class Method
extends AbstractMethod {
    private final ExceptionHandler exceptionHandler = new ExceptionHandler();
    private final AbstractFunction function;
    private Packet packet = null;
    private CountDownLatch gotPacket = new CountDownLatch(1);
    private MethodHandler handler = new DefaultHandler();
    private final EventHandler eventHandler;

    Method(AbstractFunction function, EventHandler eventHandler, MethodHandler handler) {
        super(function.getRequestNumber(), function.getResponseNumber());
        this.eventHandler = eventHandler;
        if (handler != null) {
            this.handler = handler;
        }
        switch (function.getRequestNumber()) {
            default: {
                break;
            }
            case 3: 
            case 45: {
                this.gotPacket.countDown();
            }
        }
        this.function = function;
    }

    void waitForReply(Connection c) throws ProCoreException, InterruptedException {
        while (this.gotPacket.getCount() > 0L) {
            this.gotPacket.await(30L, TimeUnit.SECONDS);
            if (this.gotPacket.getCount() <= 0L) continue;
            System.err.println("waitForReply timeout:");
            System.err.println("wait token=" + this.getToken());
        }
        if (this.packet != null) {
            this.handler.got(this.packet, this.function);
        }
    }

    EventHandler getEventHandler(EventHandler eventHandler) {
        if (this.eventHandler != null) {
            return this.eventHandler;
        }
        return eventHandler;
    }

    ByteBuffer serialize(ByteOrder byteOrder) {
        DataBuffer db = this.function.serialize(byteOrder);
        return db.getByteBuffer();
    }

    void gotPacket(Packet packet) {
        this.packet = packet;
        this.gotPacket.countDown();
    }

    void gotException(String s) {
        this.handler = new ErrorHandler(s);
        this.gotPacket.countDown();
    }

    void gotException(Packet packet) {
        this.packet = packet;
        this.handler = this.exceptionHandler;
        this.gotPacket.countDown();
    }
}

