/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.procore.cluster;

import gnu.trove.map.hash.TIntIntHashMap;
import gnu.trove.procedure.TIntIntProcedure;
import gnu.trove.set.hash.TIntHashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ValidationException;
import org.simantics.db.impl.ClusterBase;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.IntAllocatorI;
import org.simantics.db.impl.Modifier;
import org.simantics.db.impl.ResourceImpl;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.TableFactory;
import org.simantics.db.impl.TableIntAllocatorAdapter;
import org.simantics.db.impl.TableSizeListener;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncContextMultiProcedure;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.procore.cluster.IntHash;
import org.simantics.db.procore.cluster.IntHashTrait;
import org.simantics.db.procore.cluster.TableIntArraySet;
import org.simantics.db.procore.cluster.TableIntSet;

public final class ObjectTable
extends Table<int[]> {
    final TableIntAllocatorAdapter allocator = new TableIntAllocatorAdapter((Table)this);
    private TIntHashSet checkIndexSet = null;

    public ObjectTable(TableSizeListener sizeListener, int[] header, int headerBase) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase);
    }

    public ObjectTable(TableSizeListener sizeListener, int[] header, int headerBase, int[] ints) {
        super(TableFactory.getIntFactory(), sizeListener, header, headerBase, (Object)ints);
    }

    final int createObjectSet(int o1, int o2) throws DatabaseException {
        if (o1 == 0 || o1 == o2) {
            throw new DatabaseException("Illegal argument to createObejctSet");
        }
        int[] obs = new int[]{o1, o2};
        int hashBase = TableIntArraySet.create(obs, (IntAllocatorI)this.allocator);
        return this.convertRealIndexToTableIndex(hashBase);
    }

    final void deleteObjectSet(int objectIndex) throws DatabaseException {
        int hashBase = this.checkIndexAndGetRealIndex(objectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            int capacity = TableIntArraySet.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = objectIndex - 1;
            this.deleteOldElement(elementIndex, capacity);
        } else {
            int capacity = TableIntSet.getAllocatedSize((int[])this.getTable(), hashBase);
            int elementIndex = objectIndex - 4;
            this.deleteOldElement(elementIndex, capacity);
        }
    }

    public final int getObjectSetSize(int objectIndex) {
        int hashBase = this.checkIndexAndGetRealIndex(objectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            return TableIntArraySet.getSize((int[])this.getTable(), hashBase);
        }
        return TableIntSet.getSize((int[])this.getTable(), hashBase);
    }

    final int addObject(int objectIndex, int oResourceIndex) throws DatabaseException {
        int newHashBase;
        int hashBase = this.checkIndexAndGetRealIndex(objectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            if (TableIntArraySet.getSize((int[])this.getTable(), hashBase) < 5) {
                newHashBase = TableIntArraySet.addInt((int[])this.getTable(), hashBase, oResourceIndex, (IntAllocatorI)this.allocator);
            } else {
                TableIntArraySet.Ints ints = TableIntArraySet.getIntsIfValueNotFound((int[])this.getTable(), hashBase, oResourceIndex);
                if (ints.found) {
                    return 0;
                }
                this.deleteObjectSet(objectIndex);
                newHashBase = TableIntSet.create(ints.ints, (IntAllocatorI)this.allocator);
                assert (newHashBase != 0);
            }
        } else {
            newHashBase = TableIntSet.addInt((int[])this.getTable(), hashBase, oResourceIndex, (IntAllocatorI)this.allocator);
        }
        if (newHashBase == 0) {
            return 0;
        }
        int ni = this.convertRealIndexToTableIndex(newHashBase);
        return ni;
    }

    final int removeObject(int objectIndex, int oResourceIndex) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int pRef = objectIndex;
            if (oResourceIndex == pRef) {
                return 0;
            }
            return 1;
        }
        objectIndex = ClusterTraits.statementIndexGet(objectIndex);
        int hashBase = this.checkIndexAndGetRealIndex(objectIndex, 0);
        int[] table = (int[])this.getTable();
        if (TableIntArraySet.isArraySet(table, hashBase)) {
            return TableIntArraySet.removeInt(table, hashBase, oResourceIndex);
        }
        TableIntSet.removeInt(table, hashBase, oResourceIndex);
        return TableIntSet.getSize(table, hashBase);
    }

    public final int getSingleObject(int objectIndex, ClusterSupport support, Modifier modifier) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            return modifier.execute(objectIndex);
        }
        int realObjectIndex = ClusterTraits.statementIndexGet(objectIndex);
        int hashBase = this.checkIndexAndGetRealIndex(realObjectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            return TableIntArraySet.getSingleInt((int[])this.getTable(), hashBase, modifier);
        }
        return IntHash.getSingleInt((int[])this.getTable(), hashBase, modifier);
    }

    public final void foreachObject(ReadGraphImpl graph, int objectIndex, SyncMultiProcedure<Resource> procedure, Modifier modifier) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int key = modifier.execute(objectIndex);
            procedure.execute((ReadGraph)graph, (Object)new ResourceImpl(graph.getResourceSupport(), key));
            procedure.finished((ReadGraph)graph);
            return;
        }
        int realObjectIndex = ClusterTraits.statementIndexGet(objectIndex);
        int hashBase = this.checkIndexAndGetRealIndex(realObjectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            TableIntArraySet.foreachInt((int[])this.getTable(), hashBase, graph, procedure, modifier);
        } else {
            IntHash.foreachInt(graph, (int[])this.table, hashBase, procedure, modifier);
        }
    }

    public final <C> void foreachObject(ReadGraphImpl graph, int objectIndex, C context, SyncContextMultiProcedure<C, Resource> procedure, Modifier modifier) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int key = modifier.execute(objectIndex);
            procedure.execute((ReadGraph)graph, context, (Object)new ResourceImpl(graph.getResourceSupport(), key));
            procedure.finished((ReadGraph)graph, context);
            return;
        }
        int realObjectIndex = ClusterTraits.statementIndexGet(objectIndex);
        int hashBase = this.checkIndexAndGetRealIndex(realObjectIndex, 0);
        if (TableIntArraySet.isArraySet((int[])this.getTable(), hashBase)) {
            TableIntArraySet.foreachInt((int[])this.getTable(), hashBase, graph, context, procedure, modifier);
        } else {
            IntHash.foreachInt(graph, (int[])this.table, hashBase, context, procedure, modifier);
        }
    }

    public final <Context> boolean foreachObject(int objectIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        if (ClusterTraits.statementIndexIsDirect(objectIndex)) {
            int pRef = objectIndex;
            int key = modifier == null ? pRef : modifier.execute(pRef);
            return procedure.execute(context, key);
        }
        int realObjectIndex = ClusterTraits.statementIndexGet(objectIndex);
        int hashBase = this.checkIndexAndGetRealIndex(realObjectIndex, 0);
        boolean ret = TableIntArraySet.isArraySet((int[])this.getTable(), hashBase) ? TableIntArraySet.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier) : TableIntSet.foreachInt((int[])this.getTable(), hashBase, procedure, context, modifier);
        return ret;
    }

    private void checkEntry(ClusterBase cluster, int[] table, int index) throws DatabaseException {
        if (!ClusterTraits.statementIndexIsDirect(table[index])) {
            throw new ValidationException("Illegal ObjectTable entry. Entry=" + table[index] + " index=" + index);
        }
        int dr = table[index];
        cluster.checkDirectReference(dr);
    }

    public final void check(ClusterBase cluster) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.checkIndexSet = new TIntHashSet();
        } else {
            this.checkIndexSet.clear();
        }
        int count = 0;
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                assert (table[max] + 1 >= table[use]);
                this.checkIndexSet.add(p - ps);
                int e = p + table[cap];
                while (p < e) {
                    if (IntHashTrait.isFull(table[p])) {
                        this.checkEntry(cluster, table, p);
                    }
                    ++p;
                }
            } else {
                int size = -table[cap];
                assert (size > 0);
                this.checkIndexSet.add(p - ps);
                boolean free = false;
                int e = p + size;
                while (p < e) {
                    if (free) {
                        assert (table[p] == 0);
                    } else if (table[p] == 0) {
                        free = true;
                    } else {
                        this.checkEntry(cluster, table, p);
                    }
                    ++p;
                }
            }
            ++count;
        }
        assert (this.getHeader().getCount() <= count);
    }

    public final void checkObjectSetIndex(ClusterBase cluster, int i) throws DatabaseException {
        if (this.checkIndexSet == null) {
            this.check(cluster);
        }
        if (!this.checkIndexSet.contains(i - 1)) {
            throw new ValidationException("Illegal object set index=" + i);
        }
    }

    public final void printDebugInfo() {
        int[] table = (int[])this.getTable();
        int ps = this.getHeader().getOffset() + 1;
        int pe = ps + this.getTableSize();
        TIntIntHashMap stat = new TIntIntHashMap();
        TIntIntHashMap stat2 = new TIntIntHashMap();
        int p = ps;
        while (p < pe) {
            int cap;
            if (table[cap = p++] >= 0) {
                int use = p++;
                int fre = p++;
                int max = p++;
                assert (table[cap] >= table[use] + table[fre]);
                assert (table[max] == table[cap] >> 1);
                p += table[cap];
                int val = stat.get(table[use]) + 1;
                stat.put(table[use], val);
                continue;
            }
            int size = -table[cap];
            int val = stat2.get(size) + 1;
            stat2.put(size, val);
            p += size;
        }
        stat.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("object set capacity " + a + " instance count " + b);
                return true;
            }
        });
        stat2.forEachEntry(new TIntIntProcedure(){

            public boolean execute(int a, int b) {
                System.out.println("object array set capacity " + a + " instance count " + b);
                return true;
            }
        });
    }

    public <Context> boolean foreach(int setIndex, ClusterI.Procedure procedure, Context context, ClusterSupport support, Modifier modifier) throws DatabaseException {
        return this.foreachObject(setIndex, (ClusterI.ObjectProcedure)procedure, context, support, modifier);
    }
}

