/*
 * Decompiled with CFR 0.152.
 */
package fi.vtt.simantics.procore.internal;

import fi.vtt.simantics.procore.internal.ClusterChange;
import fi.vtt.simantics.procore.internal.ClusterTable;
import fi.vtt.simantics.procore.internal.SessionImplSocket;
import java.io.InputStream;
import java.util.function.Consumer;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.impl.ClusterI;
import org.simantics.db.impl.ClusterSupport;
import org.simantics.db.impl.ClusterTraitsBase;
import org.simantics.db.impl.ForEachObjectContextProcedure;
import org.simantics.db.impl.ForEachObjectProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueContextProcedure;
import org.simantics.db.impl.ForPossibleRelatedValueProcedure;
import org.simantics.db.impl.Table;
import org.simantics.db.impl.graph.ReadGraphImpl;
import org.simantics.db.procedure.SyncMultiProcedure;
import org.simantics.db.procore.cluster.ClusterBig;
import org.simantics.db.procore.cluster.ClusterImpl;
import org.simantics.db.procore.cluster.ClusterTraits;
import org.simantics.db.service.ClusterUID;

public final class ClusterWriteOnly
extends ClusterImpl {
    final SessionImplSocket sessionImpl;
    final ClusterTable clusterTable;
    private final int clusterKeyHigh;
    private short currentIndex;

    ClusterWriteOnly(ClusterUID clusterUID, int clusterKey, SessionImplSocket sessionImpl) {
        super(clusterUID, clusterKey, (ClusterSupport)sessionImpl.clusterTranslator);
        assert (sessionImpl != null);
        this.sessionImpl = sessionImpl;
        this.clusterKeyHigh = ClusterTraits.getClusterBits((int)clusterKey);
        this.cc = new ClusterChange(sessionImpl.clusterStream, this);
        this.clusterTable = sessionImpl.clusterTable;
        this.currentIndex = 1;
        this.setImportance(Long.MAX_VALUE);
    }

    boolean isNew() {
        return true;
    }

    public void releaseMemory() {
    }

    public void compact() {
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public boolean isWriteOnly() {
        return true;
    }

    public int createResource(ClusterSupport support) throws DatabaseException {
        this.cc.createResource(this.currentIndex);
        short s = this.currentIndex;
        this.currentIndex = (short)(s + 1);
        return this.clusterKeyHigh + s;
    }

    public boolean hasResource(int r, ClusterSupport support) throws DatabaseException {
        short resourceIndex = ClusterTraits.getResourceIndexFromResourceKey((int)r);
        if (ClusterTraits.getClusterKeyFromResourceKey((int)r) != this.clusterKey) {
            return false;
        }
        return resourceIndex > 0 && resourceIndex <= this.currentIndex;
    }

    private void addChange(int s, int p, int o, ClusterSupport a, byte operation) throws DatabaseException {
        this.change.op0 = operation;
        this.change.key0 = s;
        this.change.key1 = p;
        this.change.key2 = o;
        this.change.clusterUID1 = ClusterTraits.isCluster((int)this.clusterKeyHigh, (int)p) ? this.getClusterUID() : this.clusterTable.getClusterUIDByResourceKey(p);
        this.change.clusterUID2 = ClusterTraits.isCluster((int)this.clusterKeyHigh, (int)o) ? this.getClusterUID() : this.clusterTable.getClusterUIDByResourceKey(o);
        this.cc.addChange(this.change);
    }

    public ClusterI addRelation(int s, int p, int o, ClusterSupport a) throws DatabaseException {
        this.addChange(s, p, o, a, (byte)2);
        return this;
    }

    public synchronized boolean removeRelation(int s, int p, int o, ClusterSupport a) throws DatabaseException {
        this.addChange(s, p, o, a, (byte)3);
        return true;
    }

    public synchronized void denyRelation(int s, int p, int o, ClusterSupport a) throws DatabaseException {
        this.addChange(s, p, o, a, (byte)3);
    }

    public synchronized ClusterI setValue(int s, byte[] value, int length, ClusterSupport a) throws DatabaseException {
        this.sessionImpl.clusterTranslator.addStatementIndex((Object)this, s, this.getClusterUID(), (byte)4);
        this.sessionImpl.clusterTranslator.setValue((Object)this, this.clusterId, value, length);
        return this;
    }

    public ClusterI modiValueEx(int s, long voffset, int length, byte[] value, int offset, ClusterSupport support) throws DatabaseException {
        this.sessionImpl.clusterTranslator.addStatementIndex((Object)this, s, this.getClusterUID(), (byte)6);
        support.modiValue((Object)this, this.getClusterId(), voffset, length, value, offset);
        return this;
    }

    public byte[] readValueEx(int s, long voffset, int length, ClusterSupport support) throws DatabaseException {
        throw new Error("Not implemented");
    }

    public long getValueSizeEx(int rResourceId, ClusterSupport support) throws DatabaseException {
        throw new Error("Not implemented");
    }

    public synchronized void setValueEx(int s) throws DatabaseException {
    }

    public synchronized boolean removeValue(int s, ClusterSupport a) {
        throw new Error("Not implemented");
    }

    public synchronized ClusterI getClusterByResourceKey(int resourceKey, ClusterSupport support) {
        int clusterShortId = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow((int)resourceKey);
        if (this.clusterKey == clusterShortId) {
            return this;
        }
        return support.getClusterByResourceKey(resourceKey);
    }

    public synchronized int getNumberOfResources(ClusterSupport support) {
        return this.currentIndex - 1;
    }

    public boolean isEmpty() {
        return true;
    }

    public long getUsedSpace() throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public void decreaseReferenceCount(int amount) {
    }

    public void increaseReferenceCount(int amount) {
    }

    public int getReferenceCount() {
        return 1;
    }

    public byte[] getValue(int sr, ClusterSupport a) {
        throw new Error("Not implemented.");
    }

    public InputStream getValueStream(int resourceKey, ClusterSupport support) throws DatabaseException {
        throw new Error("Not implemented.");
    }

    public boolean hasValue(int r, ClusterSupport a) {
        throw new Error("Not implemented.");
    }

    public void printDebugInfo(String message, ClusterSupport support) {
        throw new Error("Not implemented.");
    }

    public void load() {
    }

    public void load(Consumer<DatabaseException> r) {
    }

    public int getSingleObject(int resourceKey, int predicateKey, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <T> int getSingleObject(int resourceKey, ForPossibleRelatedValueProcedure<T> procedure, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <C, T> int getSingleObject(int resourceKey, ForPossibleRelatedValueContextProcedure<C, T> procedure, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, int predicateKey, SyncMultiProcedure<Resource> procedure) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, int objectIndex, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public void forObjects(ReadGraphImpl graph, int resourceKey, ForEachObjectProcedure procedure) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <C> void forObjects(ReadGraphImpl graph, int resourceKey, C context, ForEachObjectContextProcedure<C> procedure) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <Context> boolean forObjects(int resourceKey, int predicateKey, ClusterI.ObjectProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public <Context> boolean forPredicates(int resourceKey, ClusterI.PredicateProcedure<Context> procedure, Context context, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public int getCompleteObjectKey(int resourceKey, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public ClusterI.CompleteTypeEnum getCompleteType(int resourceKey, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    public boolean isComplete(int resourceKey, ClusterSupport support) throws DatabaseException {
        throw new DatabaseException("Not implemented.");
    }

    @Override
    public boolean hasVirtual() {
        return false;
    }

    @Override
    public void markVirtual() {
    }

    public void load(ClusterSupport session, Runnable callback) {
        throw new Error();
    }

    public boolean contains(int resource) {
        throw new Error();
    }

    public ClusterI.ClusterTypeEnum getType() {
        return ClusterI.ClusterTypeEnum.WRITEONLY;
    }

    public int execute(int valueToModify) throws DatabaseException {
        throw new Error("Not supported");
    }

    @Override
    public ClusterBig toBig(ClusterSupport support) throws DatabaseException {
        throw new Error("Not supported");
    }

    @Override
    public void checkDirectReference(int dr) throws DatabaseException {
        throw new Error("Not supported");
    }

    @Override
    public void checkForeingIndex(int fi) throws DatabaseException {
        throw new Error("Not supported");
    }

    @Override
    public void checkObjectSetReference(int or) throws DatabaseException {
        throw new Error("Not supported");
    }

    public boolean getImmutable() {
        return false;
    }

    public void setImmutable(boolean immutable, ClusterSupport support) {
        this.sessionImpl.clusterTranslator.setImmutable((Object)this, immutable);
    }

    public boolean getDeleted() {
        return false;
    }

    public void setDeleted(boolean deleted, ClusterSupport support) {
        this.sessionImpl.clusterTranslator.setDeleted((Object)this, deleted);
    }

    public void checkValueInit() throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void checkCompleteSetReference(int cr) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void checkPredicateIndex(int pi) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void checkValue(int capacity, int index) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public void checkValueFini() throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public Table<?> getPredicateTable() {
        throw new UnsupportedOperationException();
    }

    public Table<?> getForeignTable() {
        throw new UnsupportedOperationException();
    }

    public Table<?> getCompleteTable() {
        throw new UnsupportedOperationException();
    }

    public Table<?> getValueTable() {
        throw new UnsupportedOperationException();
    }

    public int makeResourceKey(int pRef) throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    public Table<?> getObjectTable() {
        throw new UnsupportedOperationException();
    }
}

