package org.simantics.db.procore.cluster;

//Simple class for measuring time.
public class Stopwatch
{
    public final void start() { // Starts measuring time.
        start = System.nanoTime();
    }
    public final void stop() { // Ends measuring time, increases the amount of elapsed time.
        time += (double)(System.nanoTime() - start) * (double)(1e-9);
    }
    public final void reset() { // Set elapsed time to zero.
        time = 0;
    }
    public final void restart() { // Reset and starts measuring time.
        this.reset();
        this.start();
    }
    public final double elapsed() { // Returns elapsed time in seconds.
        return time;
    }
    public final double elapsedMilli() { // Returns elapsed time in milliseconds.
        return time * 1e3;
    }
    private long start;
    private double time;
}
