package org.simantics.db.layer0.variable;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * A default implementation of value accessor that has fixed binding.
 */
public abstract class ValueAccessorWithBinding implements ValueAccessor {

	public abstract Binding getBinding();
	
	@Override
	public Object getValue(ReadGraph graph, Variable context, Binding binding)
			throws DatabaseException {
		try {
			return Bindings.adapt(getValue(graph, context), getBinding(), binding);
		} catch (AdaptException e) {
			throw new DatabaseException(e);
		}
	}

	@Override
	public void setValue(WriteGraph graph, Variable context, Object value,
			Binding binding) throws DatabaseException {
		try {
			setValue(graph, context, Bindings.adapt(value, binding, getBinding()));
		} catch (AdaptException e) {
			throw new DatabaseException(e);
		}
	}
	
	@Override
	public Datatype getDatatype(ReadGraph graph, Variable context) throws DatabaseException {
		return getBinding().type();
	}
}
