/*******************************************************************************
 * Copyright (c) 2023, 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.TernaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.exception.PendingVariableException;
import org.simantics.db.layer0.variable.AbstractVariable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.layer0.variable.Variables.NodeStructure;
import org.simantics.db.request.ReadExt;
import org.simantics.db.request.RequestFlags;

/**
 * @author Antti Villberg
 * @since 1.58.0
 */
public class NodeStructureLookup extends TernaryRead<AbstractVariable, String, Boolean, Object> implements ReadExt {

	public NodeStructureLookup(AbstractVariable variable, String name, Boolean throwPending) {
		super(variable, name, throwPending);
	}

	@Override
	public Object perform(ReadGraph graph) throws DatabaseException {
		if(parameter.node == null) return null;
		NodeStructure structure = Variables.requestNodeStructure(graph, parameter.node);
		if(parameter3 && Variables.PENDING_NODE_STRUCTURE == structure) throw new PendingVariableException("");
		return structure.properties.get(parameter2);
	}

	@Override
	public int getType() {
		return RequestFlags.IMMEDIATE_UPDATE;
	}

	@Override
	public boolean isImmutable(ReadGraph graph) throws DatabaseException {
		return false;
	}

}
