/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.layer0.request;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceAsyncRead2;
import org.simantics.db.procedure.AsyncProcedure;

public class NextOrderedSetElement extends ResourceAsyncRead2<Resource> {

    public NextOrderedSetElement(Resource list, Resource element) {
        super(list, element);
    }
    
    @Override
    public void perform(AsyncReadGraph graph, final AsyncProcedure<Resource> procedure) {

        // resource = the list
        // resource2 = the element
        
        graph.forPossibleObject(resource2, resource, new AsyncProcedure<Resource>() {

            @Override
            public void exception(AsyncReadGraph graph, Throwable t) {
                procedure.exception(graph, t);
            }

            @Override
            public void execute(AsyncReadGraph graph, Resource next) {
                if(resource.equals(next)) procedure.execute(graph, null);
                else procedure.execute(graph, next);
            }
        });            
        
    }
    
}