package org.simantics.db.layer0.request;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.PersistentRead;
import org.simantics.db.request.QueryFactoryKey;
import org.simantics.db.request.QuerySerializer;
import org.simantics.layer0.Layer0;

public class HasEnumerationRange extends ResourceRead<Boolean> implements PersistentRead<Boolean> {

	private static final byte ONE = 1;
	
	public HasEnumerationRange(Resource resource) {
		super(resource);
	}

	@Override
	public Boolean perform(ReadGraph graph) throws DatabaseException {
		Layer0 L0 = Layer0.getInstance(graph);
		for(Resource range : graph.getObjects(resource, L0.HasRange)) {
			boolean enu = graph.syncRequest(new IsEnumeratedType(range));
			if(enu) return true;
		}
		return false;
	}

	@Override
	public void serializeValue(QuerySerializer serializer, Boolean value) {
		serializer.addByte(value ? ONE : 0);
	}

	private static final QueryFactoryKey queryFactoryKey = new QueryFactoryKey("org.simantics.db.layer0", HasEnumerationRange.class.getName()); 
	
	@Override
	public QueryFactoryKey classId() {
		return queryFactoryKey;
	}

}
