package org.simantics.db.layer0.adapter;

import org.simantics.databoard.Bindings;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.RelationContext;
import org.simantics.db.Resource;
import org.simantics.db.adaption.Adapter;
import org.simantics.db.procedure.AsyncProcedure;

public class LiteralIntegerStringAdapter implements Adapter<String, RelationContext> {

    @Override
    public void adapt(AsyncReadGraph g, Resource source, RelationContext s, final AsyncProcedure<String> procedure) {
        g.forValue(s.getStatement().getObject(), Bindings.INTEGER, new  ProcedureWrapper(procedure));
    }
    
    private static class ProcedureWrapper implements AsyncProcedure<Integer> {
    	AsyncProcedure<String> procedure;
    	
    	public ProcedureWrapper(AsyncProcedure<String> procedure) {
			this.procedure = procedure;
		}
    	
    	public void execute(AsyncReadGraph graph, Integer result) {
    		procedure.execute(graph, result.toString());
    	};
    	
    	@Override
    	public void exception(AsyncReadGraph graph, Throwable throwable) {
    		procedure.exception(graph, throwable);
    		
    	}
    }
    
}
