/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.db.impl.procedure;

import java.util.concurrent.atomic.AtomicBoolean;
import org.simantics.db.AsyncReadGraph;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.impl.query.QueryProcessor;
import org.simantics.db.procedure.AsyncMultiProcedure;

public class CallWrappedQueryProcedure4<Result>
implements AsyncMultiProcedure<Result> {
    private final AsyncMultiProcedure<Result> procedure;
    private final QueryProcessor.AsyncBarrier barrier;
    private final AtomicBoolean latch;

    public CallWrappedQueryProcedure4(AsyncMultiProcedure<Result> procedure, QueryProcessor.AsyncBarrier barrier) {
        this.procedure = procedure;
        this.barrier = barrier;
        this.latch = new AtomicBoolean(false);
    }

    public void execute(AsyncReadGraph graph, Result result) {
        try {
            this.procedure.execute(graph, result);
        }
        catch (Throwable t) {
            Logger.defaultLogError((String)("AsyncMultiProcedure.execute failed for " + String.valueOf(this.procedure)), (Throwable)t);
        }
    }

    public void finished(AsyncReadGraph graph) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.procedure.finished(graph);
                }
                catch (Throwable t) {
                    Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + String.valueOf(this.procedure)), (Throwable)t);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is finished)");
        }
    }

    public void exception(AsyncReadGraph graph, Throwable t) {
        if (this.latch.compareAndSet(false, true)) {
            try {
                try {
                    this.procedure.exception(graph, t);
                }
                catch (Throwable throwable) {
                    Logger.defaultLogError((String)("AsyncMultiProcedure.exception failed for " + String.valueOf(this.procedure)), (Throwable)throwable);
                    this.barrier.dec();
                }
            }
            finally {
                this.barrier.dec();
            }
        } else {
            Logger.defaultLogError((String)"Finished or exception was called many times (this time is exception)");
        }
    }
}

