/*******************************************************************************
 * Copyright (c) 2007, 2024 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy  - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl.query;

import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ResourceNotFoundException;

public class URIToResourceFactory extends QueryFactoryBase {

    @Override
    public CacheEntryBase readKeyAndValue(QueryDeserializerImpl deserializer) throws DatabaseException {
        URIToResource result = reference(deserializer);
        int value = deserializer.readResourceI();
        if(value == 0) {
        	result.except(new ResourceNotFoundException(result.id));
        } else {
        	result.setResult(value);
        	result.setReady();
        }
        return result;
    }
    
    @Override
    public <T extends CacheEntryBase> T reference(QueryDeserializerImpl deserializer) throws DatabaseException {
        return (T)deserializer.readURIToResource();
    }

}
