/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.db.impl;

import org.simantics.db.DevelopmentKeys;
import org.simantics.db.Resource;
import org.simantics.db.impl.support.ResourceSupport;
import org.simantics.db.service.ClusterUID;
import org.simantics.scl.compiler.elaboration.java.SafeExternalConstant;

final public class ResourceImpl implements Resource, SafeExternalConstant {

    public ResourceSupport support;
    public int id;

    public ResourceImpl() {
    }

    public ResourceImpl(final ResourceSupport support, final int id) {
        assert(id != 0);
        this.support = support;
        this.id = id;
    }

    @Override
    final public long getResourceId() {
        return support.getRandomAccessId(id);
    }

    @Override
    public boolean isPersistent() {
        return id > 0;
    }
    
    @Override
    public Resource get() {
        return this;
    }

    @Override
    public int hashCode() {
        return id;
    }

    @Override
    public int getThreadHash() {
        return id >>> 16;
    }
    
    @Override
    public boolean equals(Object object) {
        if (this == object)
            return true;
        else if (object == null)
            return false;
        else if (!(object instanceof ResourceImpl))
            return false;
        ResourceImpl r = (ResourceImpl)object;
        return r.id == id;
    }
    
    @Override
    public boolean equalsResource(Resource other) {
        ResourceImpl r = (ResourceImpl)other;
        return r.id == id;
    }

    @Override
    public int compareTo(Resource o) {
        if(this==o)
            return 0;
        if(o instanceof ResourceImpl)
            return id - ((ResourceImpl)o).id;
        else
            return 1;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        try {
            long rid = getResourceId();
            if(DevelopmentKeys.VERBOSE) {
                sb.append("[id=");
                sb.append(id);
                sb.append(" - rid=");
                sb.append(rid);
                sb.append(" i=");
                short ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(id);
                sb.append(ri);
                int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(id);
                sb.append(" c=");
                sb.append(ck);
                sb.append("]");
            } else {
                sb.append("[id=$");
                sb.append(rid);
                sb.append("]");
            }
        } catch (Exception e) {
            sb.append("[internal id=");
            sb.append(id);
            sb.append(", persistent resource id failed]");
        }
        return sb.toString();
    }
    public String toString(ClusterSupport support) {
        StringBuilder sb = new StringBuilder(32);
        long rid = getResourceId();
        if (DevelopmentKeys.VERBOSE) {
            sb.append("[id=");
            sb.append(id);
            sb.append(" - rid=");
            sb.append(rid);
            sb.append(" i=");
            short ri = ClusterTraitsBase.getResourceIndexFromResourceKeyNoThrow(id);
            sb.append(ri);
            int ck = ClusterTraitsBase.getClusterKeyFromResourceKeyNoThrow(id);
            sb.append(" ck=");
            sb.append(ck);
            ClusterBase cb = support.getClusterByClusterKey(ck);
            if (null != cb) {
                ClusterUID clusterUID = cb.getClusterUID();
                sb.append(" c=");
                sb.append(clusterUID.toString());
            }
            sb.append("]");
        } else {
            sb.append("[id=$");
            sb.append(rid);
            sb.append("]");
        }
        return sb.toString();
    }

}
