/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.BooleanType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.MapType;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.type.UnionType;
import org.simantics.databoard.type.VariantType;
import org.simantics.databoard.util.IdentityPair;

public class DataValueUtil {
    public static int compare(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        if (b1 == b2) {
            try {
                return b1.compare(o1, o2);
            }
            catch (RuntimeBindingException e) {
                throw e.getCause();
            }
        }
        Datatype t1 = b1.type();
        Datatype t2 = b2.type();
        int typeComparison = ((Binding)Bindings.getBindingUnchecked(Datatype.class)).compare(t1, t2);
        if (typeComparison != 0) {
            return typeComparison;
        }
        return DataValueUtil.deepCompare(t1, b1, o1, b2, o2, null);
    }

    public static boolean equals(Binding b1, Object o1, Binding b2, Object o2) throws BindingException {
        Datatype t2;
        if (b1 == b2) {
            try {
                return b1.equals(o1, o2);
            }
            catch (RuntimeBindingException e) {
                throw e.getCause();
            }
        }
        Datatype t1 = b1.type();
        if (!t1.equals(t2 = b2.type())) {
            return false;
        }
        int compare = DataValueUtil.deepCompare(t1, b1, o1, b2, o2, null);
        return compare == 0;
    }

    static int deepCompare(Datatype t, Binding b1, Object o1, Binding b2, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        assert (b1.type().equals(t));
        assert (b2.type().equals(t));
        if (t instanceof ByteType) {
            byte v1 = ((ByteBinding)b1).getValue_(o1);
            byte v2 = ((ByteBinding)b2).getValue_(o2);
            return v1 - v2;
        }
        if (t instanceof IntegerType) {
            int v2;
            int v1 = ((IntegerBinding)b1).getValue_(o1);
            return v1 < (v2 = ((IntegerBinding)b2).getValue_(o2)) ? -1 : (v1 == v2 ? 0 : 1);
        }
        if (t instanceof LongType) {
            long v2;
            long v1 = ((LongBinding)b1).getValue_(o1);
            return v1 < (v2 = ((LongBinding)b2).getValue_(o2)) ? -1 : (v1 == v2 ? 0 : 1);
        }
        if (t instanceof FloatType) {
            float v1 = ((FloatBinding)b1).getValue_(o1);
            float v2 = ((FloatBinding)b2).getValue_(o2);
            return Float.compare(v1, v2);
        }
        if (t instanceof DoubleType) {
            Double v1 = ((DoubleBinding)b1).getValue_(o1);
            Double v2 = ((DoubleBinding)b2).getValue_(o2);
            return Double.compare(v1, v2);
        }
        if (t instanceof BooleanType) {
            boolean v1 = ((BooleanBinding)b1).getValue_(o1);
            boolean v2 = ((BooleanBinding)b2).getValue_(o2);
            return v2 == v1 ? 0 : (v1 ? 1 : -1);
        }
        if (t instanceof ArrayType) {
            int l2;
            ArrayBinding a1 = (ArrayBinding)b1;
            ArrayBinding a2 = (ArrayBinding)b2;
            int l1 = a1.size(o1);
            int dif = l1 - (l2 = a2.size(o2));
            if (dif != 0) {
                return dif;
            }
            Binding c1 = a1.getComponentBinding();
            Binding c2 = a2.getComponentBinding();
            Datatype ct = c1.type();
            int i = 0;
            while (i < l1) {
                Object e2;
                Object e1 = a1.get(o1, i);
                dif = DataValueUtil.deepCompare(ct, c1, e1, c2, e2 = a2.get(o2, i), compareHistory);
                if (dif != 0) {
                    return dif;
                }
                ++i;
            }
            return 0;
        }
        if (t instanceof MapType) {
            int l2;
            MapBinding m1 = (MapBinding)b1;
            MapBinding m2 = (MapBinding)b2;
            int l1 = m1.size(o1);
            int dif = l1 - (l2 = m2.size(o2));
            if (dif != 0) {
                return dif;
            }
            Binding k1 = m1.getKeyBinding();
            Binding k2 = m2.getKeyBinding();
            Binding v1 = m1.getValueBinding();
            Binding v2 = m2.getValueBinding();
            TreeMap e1 = new TreeMap(k1);
            TreeMap e2 = new TreeMap(k2);
            m1.getAll(o1, e1);
            m2.getAll(o2, e2);
            Iterator i1 = e1.entrySet().iterator();
            Iterator i2 = e2.entrySet().iterator();
            while (i1.hasNext()) {
                Map.Entry h1 = i1.next();
                Map.Entry h2 = i2.next();
                dif = DataValueUtil.deepCompare(k1.type(), k1, h1.getKey(), k2, h2.getKey(), compareHistory);
                if (dif != 0) {
                    return dif;
                }
                dif = DataValueUtil.deepCompare(v1.type(), v1, h1.getValue(), v2, h2.getValue(), compareHistory);
                if (dif != 0) {
                    return dif;
                }
                i1.remove();
                i2.remove();
            }
            return 0;
        }
        if (t instanceof OptionalType) {
            OptionalBinding ob1 = (OptionalBinding)b1;
            OptionalBinding ob2 = (OptionalBinding)b2;
            Boolean h1 = ob1.hasValue(o1);
            Boolean h2 = ob2.hasValue(o2);
            if (!h1.booleanValue() && !h2.booleanValue()) {
                return 0;
            }
            int dif = h1.compareTo(h2);
            if (dif != 0) {
                return dif;
            }
            Binding c1 = ob1.getComponentBinding();
            Binding c2 = ob2.getComponentBinding();
            Object v1 = ob1.getValue(o1);
            Object v2 = ob2.getValue(o2);
            Datatype ct = c1.type();
            return DataValueUtil.deepCompare(ct, c1, v1, c2, v2, compareHistory);
        }
        if (t instanceof StringType) {
            StringBinding s1 = (StringBinding)b1;
            StringBinding s2 = (StringBinding)b2;
            String v1 = s1.getValue(o1);
            String v2 = s2.getValue(o2);
            return v1.compareTo(v2);
        }
        if (t instanceof UnionType) {
            Integer t2;
            UnionBinding u1 = (UnionBinding)b1;
            UnionBinding u2 = (UnionBinding)b2;
            Integer t1 = u1.getTag(o1);
            int dif = t1.compareTo(t2 = Integer.valueOf(u2.getTag(o2)));
            if (dif != 0) {
                return dif;
            }
            Object v1 = u1.getValue(o1);
            Object v2 = u2.getValue(o2);
            Binding c1 = u1.getComponentBindings()[t1];
            Binding c2 = u2.getComponentBindings()[t2];
            Datatype ct = c1.type();
            return DataValueUtil.deepCompare(ct, c1, v1, c2, v2, compareHistory);
        }
        if (t instanceof VariantType) {
            VariantBinding v1 = (VariantBinding)b1;
            VariantBinding v2 = (VariantBinding)b2;
            Datatype t1 = v1.getContentType(o1);
            Datatype t2 = v2.getContentType(o2);
            Object dataTypeBinding = Bindings.getBindingUnchecked(Datatype.class);
            int dif = ((Binding)dataTypeBinding).compare(t1, t2);
            if (dif != 0) {
                return dif;
            }
            Binding bi1 = v1.getContentBinding(o1);
            Binding bi2 = v2.getContentBinding(o2);
            Object va1 = v1.getContent(o1, bi1);
            Object va2 = v2.getContent(o2, bi2);
            return DataValueUtil.compare(bi1, va1, bi2, va2);
        }
        if (t instanceof RecordType) {
            RecordType rt = (RecordType)t;
            RecordBinding r1 = (RecordBinding)b1;
            RecordBinding r2 = (RecordBinding)b2;
            if (rt.isReferable()) {
                IdentityPair<Object, Object> p;
                if (compareHistory == null) {
                    compareHistory = new HashSet<IdentityPair<Object, Object>>();
                }
                if (compareHistory.contains(p = new IdentityPair<Object, Object>(o1, o2))) {
                    return 0;
                }
                compareHistory.add(p);
            }
            int len = rt.getComponentCount();
            int i = 0;
            while (i < len) {
                Binding c1 = r1.getComponentBindings()[i];
                Binding c2 = r2.getComponentBindings()[i];
                Object v1 = r1.getComponent(o1, i);
                Object v2 = r2.getComponent(o2, i);
                Datatype ct = c1.type();
                int dif = DataValueUtil.deepCompare(ct, c1, v1, c2, v2, compareHistory);
                if (dif != 0) {
                    return dif;
                }
                ++i;
            }
            return 0;
        }
        throw new IllegalArgumentException("Unsupported data type " + String.valueOf(t));
    }

    public static Comparator<Object> createComparator(final Binding b1, final Binding b2) {
        if (b1 == b2) {
            return b1;
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                try {
                    return DataValueUtil.compare(b1, o1, b2, o2);
                }
                catch (BindingException e) {
                    throw new RuntimeBindingException(e);
                }
            }
        };
    }
}

