/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.TreeSet;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.util.IsReferableQuery;
import org.simantics.databoard.binding.util.Result;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;

public class MapSerializer
extends Serializer.CompositeSerializer {
    Integer fixedSizeOfKey;
    Integer fixedSizeOfValue;
    Integer fixedSizeOfEntry;
    public Serializer keySerializer;
    public Serializer valueSerializer;
    MapBinding binding;

    public MapSerializer(MapBinding binding, Serializer keySerializer, Serializer valueSerializer) {
        super(IsReferableQuery.isReferable(binding.type()) != Result.No);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.binding = binding;
    }

    @Override
    public void finalizeConstruction() {
        this.fixedSizeOfKey = this.keySerializer.getConstantSize();
        this.fixedSizeOfValue = this.valueSerializer.getConstantSize();
        this.fixedSizeOfEntry = this.fixedSizeOfKey != null && this.fixedSizeOfValue != null ? Integer.valueOf(this.fixedSizeOfKey + this.fixedSizeOfValue) : null;
    }

    @Override
    public Object deserialize(DataInput in, List<Object> identities) throws IOException {
        try {
            int length = in.readInt();
            if (length < 0) {
                throw new SerializationException("Cannot use negative array length");
            }
            this.assertRemainingBytes(in, (long)length * ((long)this.keySerializer.getMinSize() + (long)this.valueSerializer.getMinSize()));
            Object[] keys = new Object[length];
            Object[] values = new Object[length];
            int i = 0;
            while (i < length) {
                keys[i] = this.keySerializer.deserialize(in, identities);
                values[i] = this.valueSerializer.deserialize(in, identities);
                ++i;
            }
            return this.binding.create(keys, values);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, List<Object> identities, Object obj) throws IOException {
        try {
            TreeSet<Object> oldKeys = new TreeSet<Object>(this.binding.getKeyBinding());
            this.binding.getKeys(obj, oldKeys);
            int length = in.readInt();
            if (length < 0) {
                throw new SerializationException("Cannot use negative array length");
            }
            this.assertRemainingBytes(in, (long)length * ((long)this.keySerializer.getMinSize() + (long)this.valueSerializer.getMinSize()));
            int i = 0;
            while (i < length) {
                Object key = this.keySerializer.deserialize(in, identities);
                Object value = this.valueSerializer.deserialize(in, identities);
                this.binding.put(obj, key, value);
                oldKeys.remove(key);
                ++i;
            }
            for (Object key : oldKeys) {
                this.binding.remove(obj, key);
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in, List<Object> identities) throws IOException, SerializationException {
        int length = in.readInt();
        if (this.fixedSizeOfEntry != null) {
            in.skipBytes(length * this.fixedSizeOfEntry);
            return;
        }
        int i = 0;
        while (i < length) {
            if (this.fixedSizeOfKey != null) {
                in.skipBytes(this.fixedSizeOfKey);
            } else {
                this.keySerializer.skip(in, identities);
            }
            if (this.fixedSizeOfValue != null) {
                in.skipBytes(this.fixedSizeOfValue);
            } else {
                this.valueSerializer.skip(in, identities);
            }
            ++i;
        }
    }

    @Override
    public void serialize(DataOutput out, TObjectIntHashMap<Object> identities, Object map) throws IOException {
        try {
            int length = this.binding.size(map);
            Object[] keys = new Object[length];
            Object[] values = new Object[length];
            this.binding.getAll(map, keys, values);
            out.writeInt(length);
            int i = 0;
            while (i < length) {
                Object key = keys[i];
                Object value = values[i];
                this.keySerializer.serialize(out, identities, key);
                this.valueSerializer.serialize(out, identities, value);
                ++i;
            }
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return null;
    }

    @Override
    public int getSize(Object obj, TObjectIntHashMap<Object> identities) throws IOException {
        try {
            int length = this.binding.size(obj);
            if (this.fixedSizeOfEntry != null) {
                return 4 + this.fixedSizeOfEntry * length;
            }
            int result = 4;
            Object[] keys = this.binding.getKeys(obj);
            int i = 0;
            while (i < length) {
                Object key = keys[i];
                Object value = this.binding.get(obj, key);
                result += this.keySerializer.getSize(key, identities);
                result += this.valueSerializer.getSize(value, identities);
                ++i;
            }
            return result;
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public int getMinSize() {
        return 4;
    }
}

