/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.util.binary.Endian;

public class LongSerializer
extends Serializer.NonRecursiveSerializer {
    LongBinding binding;

    public LongSerializer(LongBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object deserialize(byte[] data) throws IOException {
        try {
            long value = Endian.readLong(data);
            return this.binding.create(value);
        }
        catch (ArrayIndexOutOfBoundsException | BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserialize(byte[] data, Object obj) throws IOException {
        try {
            long value = Endian.readLong(data);
            this.binding.setValue(obj, value);
        }
        catch (ArrayIndexOutOfBoundsException | BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        try {
            long value = in.readLong();
            return this.binding.create(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            this.binding.setValue(obj, in.readLong());
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        in.skipBytes(8);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        try {
            long value = this.binding.getValue_(obj);
            out.writeLong(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return 8;
    }

    @Override
    public int getSize(Object obj) {
        return 8;
    }

    @Override
    public int getMinSize() {
        return 8;
    }

    public long getLong(DataInput in) throws IOException {
        return in.readLong();
    }

    public void putLong(DataOutput out, long x) throws IOException {
        out.writeLong(x);
    }
}

