/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.file;

import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.file.IFileList;
import org.simantics.databoard.file.RuntimeIOException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.serialization.SerializerScheme;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class RandomAccessBinaryList<T>
extends AbstractList<T>
implements IFileList<T>,
RandomAccess {
    RandomAccessBinary blob;
    SerializerScheme format;
    Binding binding;
    Serializer serializer;
    Index table;
    List<Object> identities = new ArrayList<Object>();
    TObjectIntHashMap<Object> identities2 = new TObjectIntHashMap();
    boolean closed = false;

    public RandomAccessBinaryList(RandomAccessBinary blob, Binding binding, long startPos, SerializerScheme format) throws IOException, SerializerConstructionException, SerializationException {
        this.format = format;
        this.blob = blob;
        this.binding = binding;
        this.serializer = format.getSerializer(binding);
        Integer sampleSize = this.serializer.getConstantSize();
        if (sampleSize == null) {
            this.table = new Table(startPos);
            blob.position(startPos);
            long length = blob.length();
            long pos = startPos;
            while (pos < length) {
                this.serializer.skip(blob);
                pos = blob.position();
                this.table.add(pos);
            }
        } else {
            long fileSize = blob.length();
            long count = (fileSize - startPos) / (long)sampleSize.intValue();
            if (count > Integer.MAX_VALUE) {
                throw new IllegalArgumentException("The blob is too large");
            }
            this.table = new Constant(startPos, sampleSize, (int)count);
        }
    }

    @Override
    public int size() throws RuntimeIOException {
        return this.table.size() - 1;
    }

    public boolean isOpen() {
        return !this.closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        RandomAccessBinaryList randomAccessBinaryList = this;
        synchronized (randomAccessBinaryList) {
            if (this.closed) {
                return;
            }
            this.closed = true;
        }
        try {
            this.blob.flush();
            this.blob.close();
        }
        catch (IOException iOException) {}
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public T get(int index) throws RuntimeIOException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            this.blob.position(this.table.get(index));
            this.identities.clear();
            return (T)this.serializer.deserialize(this.blob, this.identities);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void add(int index, T element) throws RuntimeIOException, RuntimeBindingException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (index == this.size()) {
                this.blob.position(this.table.get(index));
                this.identities2.clear();
                this.serializer.serialize(this.blob, this.identities2, element);
                this.table.add(this.blob.position());
                ++this.modCount;
                this.blob.flush();
            } else {
                this.identities2.clear();
                long len = this.serializer.getSize(element, this.identities2);
                long pos = this.table.get(index);
                this.blob.flush();
                this.blob.position(pos);
                this.blob.insertBytes(len, RandomAccessBinary.ByteSide.Left);
                this.identities2.clear();
                this.blob.position(pos);
                this.serializer.serialize(this.blob, this.identities2, element);
                assert (pos + len == this.blob.position());
                this.blob.flush();
                this.table.insert(index, pos);
                this.table.adjust(index + 1, this.table.size(), len);
                ++this.modCount;
            }
            this.blob.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public void setAll(Collection<? extends T> c) throws RuntimeIOException {
        try {
            this.blob.flush();
            if (this.table.size() > 1) {
                this.table.remove(1, this.table.size() - 1);
            }
            long zerosize = this.table.get(0);
            this.blob.position(zerosize);
            this.blob.setLength(zerosize);
            this.addAll(c);
            this.blob.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public T set(int index, T element) throws RuntimeIOException, RuntimeBindingException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            long startPos = this.table.get(index);
            long oldEndPos = this.table.get(index + 1);
            long oldSize = oldEndPos - startPos;
            this.blob.position(startPos);
            this.identities.clear();
            Object result = this.serializer.deserialize(this.blob, this.identities);
            assert (this.blob.position() == oldEndPos);
            this.identities2.clear();
            long newSize = this.serializer.getSize(element, this.identities2);
            long diff = newSize - oldSize;
            if (diff > 0L) {
                this.blob.flush();
                this.blob.position(startPos);
                this.blob.insertBytes(diff, RandomAccessBinary.ByteSide.Left);
            } else if (diff < 0L) {
                this.blob.flush();
                this.blob.position(startPos);
                this.blob.insertBytes(-diff, RandomAccessBinary.ByteSide.Left);
            }
            this.identities2.clear();
            this.blob.position(startPos);
            this.serializer.serialize(this.blob, this.identities2, element);
            assert (startPos + newSize == this.blob.position());
            this.blob.flush();
            this.table.adjust(index + 1, this.table.size(), diff);
            if (diff != 0L) {
                ++this.modCount;
            }
            this.blob.flush();
            return (T)result;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public void removeRange(int fromIndex, int toIndex) throws RuntimeIOException {
        if (fromIndex < 0 || toIndex < 0 || fromIndex > toIndex || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int count = toIndex - fromIndex;
            if (count == 0) {
                return;
            }
            long startPos = this.table.get(fromIndex);
            long endPos = this.table.get(toIndex);
            long length = endPos - startPos;
            this.blob.position(startPos);
            this.blob.removeBytes(length, RandomAccessBinary.ByteSide.Left);
            this.table.remove(fromIndex + 1, count);
            this.table.adjust(fromIndex + 1, this.table.size(), -length);
            ++this.modCount;
            this.blob.flush();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public T remove(int index) throws RuntimeIOException {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            long startPos = this.table.get(index);
            long endPos = this.table.get(index + 1);
            long length = endPos - startPos;
            this.blob.position(startPos);
            this.identities.clear();
            Object result = this.serializer.deserialize(this.blob, this.identities);
            this.blob.position(startPos);
            this.blob.removeBytes(length, RandomAccessBinary.ByteSide.Left);
            this.table.remove(index + 1, 1);
            this.table.adjust(index + 1, this.table.size(), -length);
            ++this.modCount;
            this.blob.flush();
            return (T)result;
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) throws RuntimeIOException {
        return this.addAll(0, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) throws RuntimeIOException, RuntimeBindingException {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        try {
            if (index == this.size()) {
                this.blob.position(this.table.get(index));
                this.identities2.clear();
                for (T element : c) {
                    this.serializer.serialize(this.blob, this.identities2, element);
                    this.table.add(this.blob.position());
                }
                this.blob.flush();
                ++this.modCount;
            } else {
                long startPos;
                long endPos = startPos = this.table.get(index);
                int i = 0;
                for (T element : c) {
                    this.identities2.clear();
                    long len = this.serializer.getSize(element, this.identities2);
                    this.table.insert(index + ++i, endPos += len);
                }
                this.blob.flush();
                this.blob.position(startPos);
                this.blob.insertBytes(endPos - startPos, RandomAccessBinary.ByteSide.Left);
                this.blob.position(startPos);
                for (T element : c) {
                    this.identities2.clear();
                    this.serializer.serialize(this.blob, this.identities2, element);
                }
                this.blob.flush();
                ++this.modCount;
            }
            this.blob.flush();
            return !c.isEmpty();
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public File getFile() {
        return null;
    }

    private static class Constant
    implements Index {
        long start;
        long sampleSize;
        int count;

        Constant(long start, int sampleSize, int count) {
            this.start = start;
            this.sampleSize = sampleSize;
            this.count = count;
        }

        @Override
        public void add(long position) {
            assert ((position - this.start) % this.sampleSize == 0L);
            ++this.count;
        }

        @Override
        public void set(int index, long position) {
            assert (position == this.start + (long)index * this.sampleSize);
        }

        @Override
        public void adjust(int fromIndex, int toIndex, long diff) {
        }

        @Override
        public long get(int index) {
            return this.start + (long)index * this.sampleSize;
        }

        @Override
        public void insert(int index, long position) {
            assert (position == this.start + (long)index * this.sampleSize);
            ++this.count;
        }

        @Override
        public void remove(int index, int count) {
            this.count -= count;
        }

        @Override
        public int size() {
            return this.count + 1;
        }
    }

    static interface Index {
        public long get(int var1);

        public int size();

        public void add(long var1);

        public void set(int var1, long var2);

        public void insert(int var1, long var2);

        public void remove(int var1, int var2);

        public void adjust(int var1, int var2, long var3);
    }

    private static class Table
    implements Index {
        TLongArrayList table = new TLongArrayList(32);

        Table(long start) {
            this.table.add(start);
        }

        @Override
        public void add(long position) {
            this.table.add(position);
        }

        @Override
        public void insert(int index, long position) {
            this.table.insert(index, position);
        }

        @Override
        public void set(int index, long position) {
            this.table.set(index, position);
        }

        @Override
        public void remove(int index, int length) {
            this.table.remove(index, length);
        }

        @Override
        public void adjust(int fromIndex, int toIndex, long diff) {
            if (diff == 0L) {
                return;
            }
            int index = fromIndex;
            while (index < toIndex) {
                this.table.set(index, this.table.get(index) + diff);
                ++index;
            }
        }

        @Override
        public long get(int index) {
            return this.table.get(index);
        }

        @Override
        public int size() {
            return this.table.size();
        }
    }
}

