/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.UnsupportedOperationException;
import org.simantics.databoard.type.IntegerType;

public class IntegerBindingDefault
extends IntegerBinding {
    public IntegerBindingDefault(IntegerType type) {
        super(type);
    }

    @Override
    public Object create(int value) {
        return value;
    }

    @Override
    public Object create(Integer value) {
        return value;
    }

    @Override
    public Object create(Number value) {
        if (value.getClass() == Integer.class) {
            return value;
        }
        return value.intValue();
    }

    @Override
    public Object create(String value) throws BindingException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new BindingException(e);
        }
    }

    @Override
    public Integer getValue(Object obj) throws BindingException {
        if (obj.getClass() != Integer.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Integer expected");
        }
        return (Integer)obj;
    }

    @Override
    public int getValue_(Object obj) throws BindingException {
        if (obj.getClass() != Integer.class) {
            throw new BindingException("Unexpected class " + obj.getClass().getSimpleName() + ", Integer expected");
        }
        return (Integer)obj;
    }

    @Override
    public void setValue(Object obj, Number value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Integer");
    }

    @Override
    public void setValue(Object obj, int value) throws BindingException {
        throw new UnsupportedOperationException("Cannot change the value of immutable java.lang.Integer");
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof Integer;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int i2;
        int i1 = (Integer)o1;
        return i1 < (i2 = ((Integer)o2).intValue()) ? -1 : (i1 == i2 ? 0 : 1);
    }
}

