/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.ArrayType;

public class ArrayListBinding
extends ArrayBinding {
    public ArrayListBinding(Binding componentBinding) {
        this(new ArrayType(componentBinding.type()), componentBinding);
    }

    public ArrayListBinding(ArrayType type, Binding componentBinding) {
        super(type, componentBinding);
        if (type == null) {
            throw new IllegalArgumentException("null arg");
        }
        this.type = type;
    }

    @Override
    public Object create() {
        return new ArrayList();
    }

    @Override
    public Object create(Collection<Object> collection) throws BindingException {
        return new ArrayList<Object>(collection);
    }

    @Override
    public Object create(int length, Iterator<Object> values) {
        ArrayList<Object> array = new ArrayList<Object>(length);
        while (values.hasNext()) {
            array.add(values.next());
        }
        return array;
    }

    @Override
    public Object create(Object[] values) {
        ArrayList<Object> array = new ArrayList<Object>(values.length);
        int i = 0;
        while (i < values.length) {
            array.add(values[i]);
            ++i;
        }
        return array;
    }

    @Override
    public Object get(Object array, int index) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", java.util.List expected");
        }
        List list = (List)array;
        return list.get(index);
    }

    @Override
    public void getAll(Object array, Object[] result) throws BindingException {
        List list = (List)array;
        int i = 0;
        while (i < list.size()) {
            result[i] = list.get(i);
            ++i;
        }
    }

    @Override
    public void set(Object array, int index, Object value) throws BindingException {
        List list = (List)array;
        list.set(index, value);
    }

    @Override
    public void add(Object array, int index, Object element) throws BindingException, IndexOutOfBoundsException {
        List list = (List)array;
        list.add(index, element);
    }

    @Override
    public void remove(Object array, int index, int count) throws BindingException {
        List list = (List)array;
        int i = 0;
        while (i < count) {
            list.remove(index);
            ++i;
        }
    }

    @Override
    public int size(Object array) throws BindingException {
        if (!this.isInstance(array)) {
            throw new BindingException("Unexpected class " + array.getClass().getSimpleName() + ", java.util.List expected");
        }
        List list = (List)array;
        return list.size();
    }

    @Override
    public boolean isInstance(Object obj) {
        return obj instanceof List;
    }

    @Override
    public void setSize(Object array, int newSize) throws BindingException {
        List list = (List)array;
        int oldSize = list.size();
        if (oldSize == newSize) {
            return;
        }
        if (oldSize > newSize) {
            int i = oldSize - 1;
            while (i >= newSize) {
                list.remove(i);
                --i;
            }
            return;
        }
        int c = newSize - oldSize;
        int i = 0;
        while (i < c) {
            list.add(this.componentBinding.createDefault());
            ++i;
        }
    }

    @Override
    public boolean isImmutable() {
        return false;
    }

    @Override
    public boolean isResizable() {
        return true;
    }
}

