/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.util.IdentityPair;

public abstract class FloatBinding
extends NumberBinding {
    public FloatBinding(FloatType type) {
        this.type = type;
    }

    @Override
    public FloatType type() {
        return (FloatType)this.type;
    }

    public abstract Object create(Float var1) throws BindingException;

    public abstract Object create(float var1) throws BindingException;

    @Override
    public abstract Object create(Number var1) throws BindingException;

    @Override
    public abstract Object create(String var1) throws BindingException;

    @Override
    public abstract boolean isInstance(Object var1);

    @Override
    public abstract Float getValue(Object var1) throws BindingException;

    public abstract float getValue_(Object var1) throws BindingException;

    @Override
    public abstract void setValue(Object var1, Number var2) throws BindingException;

    public abstract void setValue(Object var1, float var2) throws BindingException;

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        float v1 = this.getValue_(o1);
        float v2 = this.getValue_(o2);
        return Float.compare(v1, v2);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        float v = this.getValue_(value);
        return Float.floatToIntBits(v);
    }

    public Object createUnchecked(float value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked(Float value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }
}

