/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.accessor.binary;

import java.io.IOException;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.Accessor;
import org.simantics.databoard.accessor.StringAccessor;
import org.simantics.databoard.accessor.binary.BinaryObject;
import org.simantics.databoard.accessor.error.AccessorConstructionException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.accessor.error.ReferenceException;
import org.simantics.databoard.accessor.event.Event;
import org.simantics.databoard.accessor.event.ValueAssigned;
import org.simantics.databoard.accessor.file.FileStringAccessor;
import org.simantics.databoard.accessor.impl.AccessorParams;
import org.simantics.databoard.accessor.impl.ListenerEntry;
import org.simantics.databoard.accessor.interestset.StringInterestSet;
import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.binary.Blob;
import org.simantics.databoard.util.binary.Endian;
import org.simantics.databoard.util.binary.UTF8;

public class BinaryString
extends BinaryObject
implements StringAccessor,
FileStringAccessor {
    public BinaryString(BinaryObject parent, Blob blob, StringType type, AccessorParams params) throws AccessorConstructionException {
        super(parent, blob, type, params);
    }

    @Override
    public StringType type() {
        return (StringType)this.type;
    }

    @Override
    Event applyLocal(Event e, boolean makeRollback) throws AccessorException {
        ValueAssigned rollback;
        ValueAssigned valueAssigned = rollback = makeRollback ? new ValueAssigned(Bindings.STRING, this.getValue()) : null;
        if (e instanceof ValueAssigned) {
            ValueAssigned va = (ValueAssigned)e;
            if (va.newValue == null) {
                throw new AccessorException("String value expected, got null");
            }
            this.setValueNoflush(va.newValue.getBinding(), va.newValue.getValue());
            return rollback;
        }
        throw new AccessorException("Cannot apply " + e.getClass().getName() + " to String");
    }

    @Override
    public <T extends Accessor> T getComponent(ChildReference reference) throws AccessorConstructionException {
        if (reference == null) {
            return (T)this;
        }
        throw new ReferenceException(String.valueOf(reference.getClass()) + " is not a subreference of StringType");
    }

    @Override
    public Object getValue(Binding binding) throws AccessorException {
        try {
            StringBinding bb = (StringBinding)binding;
            String v = this.getValue();
            return bb.create(v);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }

    @Override
    public String getValue() throws AccessorException {
        assert (this.b.isOpen());
        this.readLock();
        try {
            this.b.position(0L);
            int utflen = Endian.readDynamicUInt32(this.b);
            String string = UTF8.readModifiedUTF(this.b, utflen);
            return string;
        }
        catch (IOException e) {
            throw new AccessorException(e);
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public void setValueNoflush(String string) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.b.position(0L);
                int strlen = UTF8.getModifiedUTF8EncodingByteLength(string);
                int lenlen = Endian.getDynamicUInt32Length(strlen);
                this.b.setLength(strlen + lenlen);
                Endian.writeDynamicUInt32(this.b, strlen);
                UTF8.writeModifiedUTF(this.b, string);
                ListenerEntry le = this.listeners;
                while (le != null) {
                    StringInterestSet is = (StringInterestSet)le.getInterestSet();
                    if (is.inNotifications()) {
                        ValueAssigned e = new ValueAssigned(Bindings.STRING, is.inValues() ? string : null);
                        this.emitEvent(le, e);
                    }
                    le = le.next;
                }
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValue(String string) throws AccessorException {
        assert (this.b.isOpen());
        this.writeLock();
        try {
            try {
                this.setValueNoflush(string);
                this.b.flush();
            }
            catch (IOException e) {
                throw new AccessorException(e);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void setValueNoflush(Binding binding, Object newValue) throws AccessorException {
        try {
            String nv = ((StringBinding)binding).getValue(newValue);
            this.setValueNoflush(nv);
        }
        catch (BindingException e) {
            throw new AccessorException(e);
        }
    }
}

