/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.units;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import org.simantics.databoard.accessor.reference.ChildReference;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;

/**
 * This utility class contains a toolkit for synchronization of objects.
 * 
 * @author toni.kalajainen
 */
public class SynchronizationUtil {

	/**
	 * Compare arrays
	 * 
	 * @param arrayBinding 
	 * @param oldArray
	 * @param newArray
	 * @param idRef reference identifier in item
	 * @return Compare raport
	 */
	public <T> CompareRaport<T> compareArrays(ArrayBinding arrayBinding, T oldArray, T newArray, ChildReference idRef)
	{
		Binding cb = arrayBinding.componentBinding;
		
		CompareRaport<T> result = new CompareRaport<T>();
		
		//Set<T> oldIds = new HashSet<T>(  )
		
		return result;
	}
	
//	public <T> CompareRaport<T> compareMaps(MapBinding mapBinding, T oldMap, T newMap, ChildReference idRef)
//	{
//		
//	}
	
	static class CompareRaport<T> {
		
		public Set<T> addedItems = new HashSet<T>();
		public Set<T> removedItems = new HashSet<T>();
		public Map<T, T> correspondences = new HashMap<T, T>();
		
		public T[] addedIndices;
		public T[] removedIndices;
		public Map<Integer, Integer> indiceCorrespondence;
		
	}
	
}
