/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.type;

import java.util.Set;

import org.simantics.databoard.util.IdentityPair;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;

public class FloatType extends NumberType {
	    
    public FloatType() {}
    public FloatType(String unit) {
    	setUnit( unit );
    }
    public FloatType(String unit, Range range) {
    	setUnit( unit );
    	setRange(range);
    }    
    public FloatType(String unit, String range) {
    	setUnit( unit );
    	setRange(range);
    }    
    
    public float minValue() {
    	Range range = getRange();
    	if (range==null) return -Float.MAX_VALUE;
    	Limit l = range.getLower();
    	float value = l.getValue().floatValue();
    	
    	// Won't work
    	if (l.isExclusive()) value+= Float.MIN_VALUE;
    	
    	return value;
    }
    
    public float maxValue() {
    	Range range = getRange();
    	if (range==null) return Float.MAX_VALUE;
    	Limit l = range.getUpper();
    	float value = l.getValue().floatValue();
    	
    	// Won't work
    	if (l.isExclusive()) value-= Float.MIN_VALUE;
    	
    	return value;
    }    
       
    @Override
    protected boolean deepEquals(Object obj, Set<IdentityPair<Datatype, Datatype>> compareHistory) {
		if (this==obj) return true;
		if ( !hasEqualMetadata(obj) ) return false;
		return obj instanceof FloatType;
    }

    @Override
    public int hashCode() {
    	return 0xaa55996 + metadataHashCode();
    }  

    @Override
	public void accept(Visitor1 v, Object obj) {
	    v.visit(this, obj);        
	}

	@Override
	public <T> T accept(Visitor<T> v) {
	    return v.visit(this);
	}	
	
}
