/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.binding.mutable;

import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.MutableByte;
import org.simantics.databoard.type.ByteType;

/**
 * Binds java.lang.Byte to {@link MutableByte}
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class MutableByteBinding extends ByteBinding {
	
	public MutableByteBinding(ByteType type) {
		super( type );
	}

	@Override
	public Object create(byte value) {
		MutableByte result = new MutableByte();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Byte value) {
		MutableByte result = new MutableByte();
		result.value = value;
		return result;
	}

	@Override
	public Object create(Number value) {
		MutableByte result = new MutableByte();
		result.value = value.byteValue();
		return result;
	}

	@Override
	public Object create(String value) throws BindingException {
		try {
			byte x = Byte.valueOf( value );
			MutableByte result = new MutableByte();
			result.value = x;
			return result;
		} catch (java.lang.NumberFormatException e) {
			throw new BindingException( e );
		}
	}

	@Override
	public byte getValue_(Object obj) throws BindingException {
		MutableByte result = (MutableByte) obj;
		return result.value;
	}

	@Override
	public Byte getValue(Object obj) throws BindingException {
		MutableByte result = (MutableByte) obj;
		return result.value;
	}

	@Override
	public boolean isInstance(Object obj) {
		return obj instanceof MutableByte;
	}

	@Override
	public void setValue(Object obj, byte value) throws BindingException {
		MutableByte result = (MutableByte) obj;
		result.value = value;
	}

	@Override
	public void setValue(Object obj, Number value) throws BindingException {
		MutableByte result = (MutableByte) obj;
		result.value = value.byteValue();
	}
	
}

