/*******************************************************************************
 *  Copyright (c) 2010 Association for Decentralized Information Management in
 *  Industry THTH ry.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 *
 *  Contributors:
 *      VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.adapter;

import org.simantics.databoard.binding.Binding;

public class AdapterRequest {

	Binding domain;
	Binding range;
	boolean typeAdapter;
	boolean mustClone;
	
	public AdapterRequest(Binding domain, Binding range)
	{
		if (domain==null||range==null) throw new IllegalArgumentException("null arg");
		this.domain = domain;
		this.range = range;
	}

	public AdapterRequest(Binding domain, Binding range, boolean typeAdapter, boolean mustClone)
	{
		if (domain==null||range==null) throw new IllegalArgumentException("null arg");
		this.domain = domain;
		this.range = range;
		this.typeAdapter = typeAdapter;
		this.mustClone = mustClone;
	}
	
	public Binding getDomain() {
		return domain;
	}
	
	public Binding getRange() {
		return range;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + domain.hashCode();
		result = prime * result + range.hashCode();
		result = prime * result + (typeAdapter ? 1231 : 1237);
		result = prime * result + (mustClone ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null) return false;
		if (obj instanceof AdapterRequest == false) return false;
		AdapterRequest other = (AdapterRequest) obj;
		return other.domain.equals(domain) && other.range.equals(range) && typeAdapter==other.typeAdapter && mustClone==other.mustClone;
	}

}
