/*******************************************************************************
 * Copyright (c) 2010- Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *    VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.databoard.accessor.reference;

import org.simantics.databoard.util.URIUtil;

/**
 * Label Reference is a reference that can be consumed by any Accessor interface. 
 * If contains the reference in string format
 *
 * @author Toni Kalajainen <toni.kalajainen@vtt.fi>
 */
public class LabelReference extends ChildReference {
	
	public String label;
	
	public LabelReference(String label) {
		this.label = label;
	}
	
	public LabelReference(String label, ChildReference child) {
		super(child);
		this.label = label;
	}
	
	@Override
	public String toString(boolean labelReference) {	
		return URIUtil.encodeURI(label);
	}

	@Override
	public ChildReference clone() {
		return new LabelReference(label, childReference==null ? null : childReference.clone());
	}
	
	@Override
	public boolean equals(Object obj) {
		if (obj instanceof LabelReference == false) return false;
		LabelReference other = (LabelReference) obj;
		if (!other.label.equals(label)) return false;
		if (other.hasChildReference() != hasChildReference()) return false;
		if (hasChildReference() && !other.childReference.equals(childReference)) return false;
		return true;
	}
	
	@Override
	public int hashCode() {
		int hash = 4699956 + 37 * label.hashCode();
		if (hasChildReference()) hash = 31*hash + childReference.hashCode();		
		return hash;
	}	
	
	
}
