/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.charts.editor;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.charts.Activator;
import org.simantics.charts.editor.TimeSeriesEditor;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.util.PrintUtil;
import org.simantics.utils.ui.dialogs.ShowMessage;

public class ExportToPdfHandler
extends AbstractHandler {
    FileDialog fd;
    Display display = PlatformUI.createDisplay();

    public ExportToPdfHandler() {
        Shell shell = this.display.getActiveShell();
        this.fd = new FileDialog(shell, 8192);
        this.fd.setText("Select PDF File");
        this.fd.setFilterExtensions(new String[]{"*.pdf"});
        this.fd.setFilterNames(new String[]{"PDF Documents"});
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        TimeSeriesEditor editor = (TimeSeriesEditor)HandlerUtil.getActiveEditor((ExecutionEvent)event);
        final TrendNode trend = editor.trendNode;
        String name = trend.getTrendSpec().name;
        this.fd.setText("Export " + name + " to PDF");
        String filename = this.fd.open();
        if (filename == null) {
            return null;
        }
        final File f = new File(filename);
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    monitor.setTaskName("Exporting");
                    PrintUtil pu = new PrintUtil();
                    pu.addTrendPage(trend);
                    try {
                        pu.printPdf(f);
                        System.out.println("Printed Trend to " + String.valueOf(f));
                    }
                    catch (IOException e1) {
                        throw new InvocationTargetException(e1);
                    }
                    monitor.setTaskName("Done");
                    Toolkit toolkit = Toolkit.getDefaultToolkit();
                    Clipboard clipboard = toolkit.getSystemClipboard();
                    StringSelection strSel = new StringSelection(f.getAbsolutePath());
                    clipboard.setContents(strSel, null);
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(r);
        }
        catch (InvocationTargetException e) {
            ShowMessage.showError((String)e.getCause().getClass().getName(), (String)e.getCause().getMessage());
            Status s = new Status(4, "org.simantics.charts", "PDF Export failed: " + e.getCause().getMessage(), e.getCause());
            Activator.getDefault().getLog().log((IStatus)s);
        }
        catch (InterruptedException e) {
            Status s = new Status(4, "org.simantics.charts", "PDF Export failed: " + e.getCause().getMessage(), e.getCause());
            Activator.getDefault().getLog().log((IStatus)s);
        }
        return null;
    }

    public void dispose() {
        if (this.display != null) {
            this.display = null;
        }
        super.dispose();
    }
}

