# Simantics/Chart module documentation

## Chart

Chart represents a TimeSeriesChart instance in Simantics ontology (`http://www.simantics.org/Charts-1.2/TimeSeriesChart`).
Instances of Chart can be used as a parameter in the following SCL functions.

::value[createChart, createChartInGroup, createNamedChart, chartsOf, chartByPath]

## Chart Items

Chart items represent an Item instance in Simantics ontology (`http://www.simantics.org/Charts-1.2/Chart/Item`).
Instances of ChartItem can be used as a parameter in the following SCL functions.

::value[addChartItems, linkSubToChart, adjustChartItem, chartItemsOf, chartItemByIndex, chartItemByLabel]

::data[ChartItemSpec]

## Chart Groups

Chart Groups are intended for grouping a set of charts together.

Chart Group is a ChartGroup instance in Simantics ontology (`http://www.simantics.org/Charts-1.2/ChartGroup`).
Instances of ChartGroup can be used as a parameter in the following SCL functions.

::value[createChartGroup, createNamedChartGroup, chartGroupByPath]

## Export subscription data as CSV

::data[CSVExportPlan]
::data[SubscriptionCSVExportPlan]

::value[exportSubscriptionsCSV]
::value[exportSubscriptionsCSVWithCharset]
::value[columnSeparatorFromString]
::value[decimalSeparatorFromString]
::value[exportInterpolationFromString]
