/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.browsing.ui.model.sorters.Sorter;
import org.simantics.browsing.ui.model.sorters.SorterRule;
import org.simantics.charts.query.TrendItemQuery;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.RuntimeDatabaseException;
import org.simantics.trend.configuration.TrendItem;

public class ChartSorterRule implements SorterRule, Sorter {

	@Override
	public boolean isCompatible(Class<?> contentType) {
		return contentType.equals(Resource.class);
	}

	@Override
	public Sorter getSorter(ReadGraph graph, Object content) throws DatabaseException {
		return this;
	}
	
	@Override
	public void sort(ReadGraph graph, BrowseContext context, List<NodeContext> nodes) throws DatabaseException 
	{
		try {
			ChartItemComparator cic = new ChartItemComparator();
			cic.graph = graph;
			Collections.sort(nodes, cic);
		} catch (RuntimeDatabaseException e) {
			if (e.getCause()!=null && e.getCause() instanceof DatabaseException) throw (DatabaseException) e.getCause();
			throw e;
		}
		
	}
	
	static class ChartItemComparator implements Comparator<NodeContext> {
		ReadGraph graph;

		@Override
		public int compare(NodeContext nc1, NodeContext nc2) {
			Resource r1 = (Resource) nc1.getConstant(BuiltinKeys.INPUT);
			Resource r2 = (Resource) nc2.getConstant(BuiltinKeys.INPUT);
			
			try {
				TrendItem ti1 = graph.sync( new TrendItemQuery(r1) );
				TrendItem ti2 = graph.sync( new TrendItemQuery(r2) );
				return ti1.compareTo(ti2);
			} catch (DatabaseException e) {
				throw new RuntimeDatabaseException(e);
			}
		}
	}

	
}
