/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.charts.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.type.Datatype;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.CommentMetadata;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.RVI;
import org.simantics.db.layer0.variable.VariableReference;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.preferences.SubscriptionPreferences;

/**
 * @author Tuukka Lehtonen
 */
public class AddSubscriptionItems extends WriteRequest {

    Resource                      subscription;
    Collection<VariableReference> references;
    public List<Resource>         result;

    private AddSubscriptionItems(Resource subscription, Collection<VariableReference> references) {
        this.subscription = subscription;
        this.references = references;
    }

    @Override
    public void perform(WriteGraph graph) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance(graph);
        ModelingResources mr = ModelingResources.getInstance(graph);
        result = new ArrayList<Resource>(references.size());

        for (VariableReference ref : references) {
            if (ref.getVariableId() == null)
                continue;

            Resource subscriptionItem = graph.newResource();
            graph.claim(subscriptionItem, l0.InstanceOf, null, mr.Subscription_Item);
            graph.claim(subscription, l0.ConsistsOf, subscriptionItem);
            graph.claimLiteral(subscriptionItem, l0.HasName, UUID.randomUUID().toString(), Bindings.STRING);
            if (ref.getLabel() != null)
                graph.claimLiteral(subscriptionItem, l0.HasLabel, ref.getLabel(), Bindings.STRING);
        	Binding rviBinding = graph.getService(Databoard.class).getBindingUnchecked( RVI.class );            
            graph.claimLiteral(subscriptionItem, mr.Subscription_Item_VariableId, l0.RVI, ref.getVariableId(), rviBinding);

            if (ref.getDatatype() != null)
                graph.claimLiteral(subscriptionItem, mr.Subscription_Item_Datatype,
                        l0.DataType, ref.getDatatype(),
                        Bindings.getBindingUnchecked(Datatype.class));
            
            IEclipsePreferences pn = InstanceScope.INSTANCE.getNode( SubscriptionPreferences.P_NODE );
            
            // Interval
            {            	
                Double si = pn.getDouble(SubscriptionPreferences.P_SUBSCRIPTION_INTERVAL, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_INTERVAL);
                if ( si != null ) {
                	graph.claimLiteral(subscriptionItem, mr.Subscription_Item_SamplingInterval, si, Bindings.DOUBLE);
                }
            }
            
            // Deadband
            {            	
                Double db = pn.getDouble(SubscriptionPreferences.P_SUBSCRIPTION_DEADBAND, SubscriptionPreferences.DEFAULT_SUBSCRIPTION_DEADBAND);
                if ( db != null ) {
                	graph.claimLiteral(subscriptionItem, mr.Subscription_Item_Deadband, db, Bindings.DOUBLE);
                }
            }
            
            CommentMetadata cm = graph.getMetadata(CommentMetadata.class);
            graph.addMetadata(cm.add("Created subscription item " + subscriptionItem + " [" + ref.getVariableId().toString(graph) + "]"));
            
            result.add( subscriptionItem );
        }
    }

}
