/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.swt;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jface.viewers.ISelection;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.ResourceArray;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyPageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyPageUtil.class);
    public static final int MAX_SELECTION_LENGTH_TO_SHOW = 5;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String computeTitle(ReadGraph graph, ISelection selection) throws DatabaseException {
        boolean sameTypes = true;
        try {
            ResourceArray[] ras = ResourceAdaptionUtils.toResourceArrays((Object)selection);
            if (ras.length == 0) {
                return null;
            }
            Collection types = null;
            ResourceArray[] resourceArrayArray = ras;
            int n = ras.length;
            int n2 = 0;
            while (n2 < n) {
                ResourceArray ra = resourceArrayArray[n2];
                if (ra.isEmpty()) {
                    return null;
                }
                if (types == null) {
                    types = graph.getPrincipalTypes(ra.resources[0]);
                } else {
                    Collection ts = graph.getPrincipalTypes(ra.resources[0]);
                    ts.removeAll(types);
                    if (!ts.isEmpty()) {
                        sameTypes = false;
                        break;
                    }
                }
                ++n2;
            }
            if (sameTypes) {
                if (!graph.hasStatement(ras[0].resources[0])) {
                    return null;
                }
                String name = PropertyPageUtil.safeGetName(graph, ras[0].resources[0]);
                if (name == null) {
                    return null;
                }
                if (ras.length <= 1) return name;
                return (String)name + " [" + ras.length + "]";
            }
            ArrayList<Object> names = new ArrayList<Object>(ras.length);
            boolean truncate = ras.length > 5;
            int end = Math.min(ras.length, 5);
            int missing = ras.length - end;
            int i = 0;
            while (true) {
                String name;
                if (i >= end) {
                    if (!names.isEmpty()) break;
                    return null;
                }
                if (graph.hasStatement(ras[i].resources[0]) && (name = PropertyPageUtil.safeGetName(graph, ras[i].resources[0])) != null) {
                    names.add(name);
                }
                ++i;
            }
            if (!truncate) return ((Object)names).toString();
            names.add("+ " + missing + " more...");
            return ((Object)names).toString();
        }
        catch (Throwable t) {
            LOGGER.error("Failed to compute title for selection {}", (Object)selection, (Object)t);
            return null;
        }
    }

    private static String safeGetName(ReadGraph g, Resource r) throws DatabaseException {
        Layer0 L0 = (Layer0)g.l0();
        String name = (String)g.getPossibleRelatedValue(r, L0.HasName, (Binding)Bindings.STRING);
        String label = (String)g.getPossibleRelatedValue(r, L0.HasLabel, (Binding)Bindings.STRING);
        if (name == null && label == null) {
            return null;
        }
        return NameUtils.getSafeLabel((ReadGraph)g, (Resource)r);
    }
}

