/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable.override;

import org.eclipse.nebula.widgets.nattable.copy.command.CopyDataToClipboardCommand;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.serializing.ISerializer;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;

public class CopyDataToClipboardSerializer
implements ISerializer {
    public static final int COPY_THRESHOLD = 500000;
    private final ILayerCell[][] copiedCells;
    private final CopyDataToClipboardCommand command;

    public CopyDataToClipboardSerializer(ILayerCell[][] copiedCells, CopyDataToClipboardCommand command) {
        this.copiedCells = copiedCells;
        this.command = command;
    }

    public void serialize() {
        String cellDelimeter = this.command.getCellDelimeter();
        String rowDelimeter = this.command.getRowDelimeter();
        TextTransfer textTransfer = TextTransfer.getInstance();
        StringBuilder textData = new StringBuilder();
        int count = 0;
        ILayerCell[][] iLayerCellArray = this.copiedCells;
        int n = this.copiedCells.length;
        int n2 = 0;
        while (n2 < n) {
            ILayerCell[] cells = iLayerCellArray[n2];
            count += cells.length;
            ++n2;
        }
        if (count <= 500000) {
            int currentRow = 0;
            ILayerCell[][] iLayerCellArray2 = this.copiedCells;
            int n3 = this.copiedCells.length;
            n = 0;
            while (n < n3) {
                ILayerCell[] cells = iLayerCellArray2[n];
                int currentCell = 0;
                ILayerCell[] iLayerCellArray3 = cells;
                int n4 = cells.length;
                int n5 = 0;
                while (n5 < n4) {
                    String delimeter;
                    ILayerCell cell = iLayerCellArray3[n5];
                    String string = delimeter = ++currentCell < cells.length ? cellDelimeter : "";
                    if (cell != null) {
                        textData.append(this.getTextForCell(cell) + delimeter);
                    } else {
                        textData.append(delimeter);
                    }
                    ++n5;
                }
                if (++currentRow < this.copiedCells.length) {
                    textData.append(rowDelimeter);
                }
                ++n;
            }
        } else {
            textData.append("Too many cells copied (" + count + ")");
        }
        if (textData.length() > 0) {
            Clipboard clipboard = new Clipboard(Display.getDefault());
            try {
                clipboard.setContents(new Object[]{textData.toString()}, new Transfer[]{textTransfer});
            }
            finally {
                clipboard.dispose();
            }
        }
    }

    protected String getTextForCell(ILayerCell cell) {
        return String.valueOf(cell.getDataValue());
    }

    protected final CopyDataToClipboardCommand getCommand() {
        return this.command;
    }
}

