/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable.override;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.VisualRefreshEvent;

public abstract class AbstractRowHideShowLayer2
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private Int2IntOpenHashMap cachedVisibleRowIndexOrder;
    private Int2IntOpenHashMap cachedVisibleRowPositionOrder;
    private Int2IntOpenHashMap cachedHiddenRowIndexToPositionMap;
    protected final Int2IntOpenHashMap startYCache = new Int2IntOpenHashMap();

    public AbstractRowHideShowLayer2(IUniqueIndexLayer underlyingLayer) {
        super((ILayer)underlyingLayer);
    }

    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateCache();
            }
        } else if (event instanceof VisualRefreshEvent) {
            this.startYCache.clear();
        }
        super.handleLayerEvent(event);
    }

    public int getColumnPositionByIndex(int columnIndex) {
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getColumnPositionByIndex(columnIndex);
    }

    public int getRowCount() {
        return this.getCachedVisibleRowIndexes().size();
    }

    public int getRowIndexByPosition(int rowPosition) {
        if (rowPosition < 0 || rowPosition >= this.getRowCount()) {
            return -1;
        }
        return this.getCachedVisibleRowPositons().get(rowPosition);
    }

    public int getRowPositionByIndex(int rowIndex) {
        return this.getCachedVisibleRowIndexes().get(rowIndex);
    }

    public Collection<Integer> getRowPositionsByIndexes(Collection<Integer> rowIndexes) {
        IntOpenHashSet rowPositions = new IntOpenHashSet();
        for (int rowIndex : rowIndexes) {
            rowPositions.add(this.getRowPositionByIndex(rowIndex));
        }
        return rowPositions;
    }

    public int localToUnderlyingRowPosition(int localRowPosition) {
        int rowIndex = this.getRowIndexByPosition(localRowPosition);
        return ((IUniqueIndexLayer)this.getUnderlyingLayer()).getRowPositionByIndex(rowIndex);
    }

    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        int rowIndex = this.getUnderlyingLayer().getRowIndexByPosition(underlyingRowPosition);
        int rowPosition = this.getRowPositionByIndex(rowIndex);
        if (rowPosition >= 0) {
            return rowPosition;
        }
        if (this.cachedHiddenRowIndexToPositionMap.containsKey(rowIndex)) {
            return this.cachedHiddenRowIndexToPositionMap.get(rowIndex);
        }
        return -1;
    }

    public Collection<Range> underlyingToLocalRowPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingRowPositionRanges) {
        ArrayList<Range> localRowPositionRanges = new ArrayList<Range>();
        for (Range underlyingRowPositionRange : underlyingRowPositionRanges) {
            int startRowPosition = this.getAdjustedUnderlyingToLocalStartPosition(sourceUnderlyingLayer, underlyingRowPositionRange.start, underlyingRowPositionRange.end);
            int endRowPosition = this.getAdjustedUnderlyingToLocalEndPosition(sourceUnderlyingLayer, underlyingRowPositionRange.end, underlyingRowPositionRange.start);
            if (startRowPosition <= -1) continue;
            localRowPositionRanges.add(new Range(startRowPosition, endRowPosition));
        }
        return localRowPositionRanges;
    }

    private int getAdjustedUnderlyingToLocalStartPosition(ILayer sourceUnderlyingLayer, int startUnderlyingPosition, int endUnderlyingPosition) {
        int localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition);
        int offset = 0;
        while (localStartRowPosition < 0 && startUnderlyingPosition + offset < endUnderlyingPosition) {
            localStartRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, startUnderlyingPosition + offset++);
        }
        return localStartRowPosition;
    }

    private int getAdjustedUnderlyingToLocalEndPosition(ILayer sourceUnderlyingLayer, int endUnderlyingPosition, int startUnderlyingPosition) {
        int localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - 1);
        int offset = 0;
        while (localEndRowPosition < 0 && endUnderlyingPosition - offset > startUnderlyingPosition) {
            localEndRowPosition = this.underlyingToLocalRowPosition(sourceUnderlyingLayer, endUnderlyingPosition - offset++);
        }
        return localEndRowPosition + 1;
    }

    public int getHeight() {
        int lastRowPosition = this.getRowCount() - 1;
        return this.getStartYOfRowPosition(lastRowPosition) + this.getRowHeightByPosition(lastRowPosition);
    }

    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY((ILayer)this, (int)y);
    }

    public int getStartYOfRowPosition(int localRowPosition) {
        int index = this.startYCache.get(localRowPosition);
        if (index >= 0) {
            return index;
        }
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        int underlyingPosition = this.localToUnderlyingRowPosition(localRowPosition);
        if (underlyingPosition < 0) {
            return -1;
        }
        int underlyingStartY = underlyingLayer.getStartYOfRowPosition(underlyingPosition);
        if (underlyingStartY < 0) {
            return -1;
        }
        for (Integer hiddenIndex : this.getHiddenRowIndexes()) {
            int hiddenPosition = underlyingLayer.getRowPositionByIndex(hiddenIndex.intValue());
            if (hiddenPosition < 0 || hiddenPosition > underlyingPosition) continue;
            underlyingStartY -= underlyingLayer.getRowHeightByPosition(hiddenPosition);
        }
        this.startYCache.put(localRowPosition, underlyingStartY);
        return underlyingStartY;
    }

    public abstract boolean isRowIndexHidden(int var1);

    public abstract Collection<Integer> getHiddenRowIndexes();

    protected void invalidateCache() {
        this.cachedVisibleRowIndexOrder = null;
        this.cachedVisibleRowPositionOrder = null;
        this.cachedHiddenRowIndexToPositionMap = null;
        this.startYCache.clear();
    }

    private Int2IntOpenHashMap getCachedVisibleRowIndexes() {
        if (this.cachedVisibleRowIndexOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowIndexOrder;
    }

    private Int2IntOpenHashMap getCachedVisibleRowPositons() {
        if (this.cachedVisibleRowPositionOrder == null) {
            this.cacheVisibleRowIndexes();
        }
        return this.cachedVisibleRowPositionOrder;
    }

    protected void cacheVisibleRowIndexes() {
        this.cachedVisibleRowIndexOrder = new Int2IntOpenHashMap();
        this.cachedVisibleRowPositionOrder = new Int2IntOpenHashMap();
        this.cachedHiddenRowIndexToPositionMap = new Int2IntOpenHashMap();
        this.startYCache.clear();
        this.cachedVisibleRowPositionOrder.defaultReturnValue(-1);
        this.cachedVisibleRowIndexOrder.defaultReturnValue(-1);
        this.cachedHiddenRowIndexToPositionMap.defaultReturnValue(-1);
        this.startYCache.defaultReturnValue(-1);
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int rowPosition = 0;
        int parentRowPosition = 0;
        while (parentRowPosition < underlyingLayer.getRowCount()) {
            int rowIndex = underlyingLayer.getRowIndexByPosition(parentRowPosition);
            if (!this.isRowIndexHidden(rowIndex)) {
                this.cachedVisibleRowIndexOrder.put(rowIndex, rowPosition);
                this.cachedVisibleRowPositionOrder.put(rowPosition, rowIndex);
                ++rowPosition;
            } else {
                this.cachedHiddenRowIndexToPositionMap.put(rowIndex, rowPosition);
            }
            ++parentRowPosition;
        }
    }
}

