/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.nattable;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

public class GETreeRowModel<T>
implements ITreeRowModel<T> {
    private final IntOpenHashSet expandedIndexes = new IntOpenHashSet();
    private final Collection<ITreeRowModelListener> listeners = new HashSet<ITreeRowModelListener>();
    private final ITreeData<T> treeData;

    public GETreeRowModel(ITreeData<T> treeData) {
        this.treeData = treeData;
    }

    public void registerRowGroupModelListener(ITreeRowModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (ITreeRowModelListener listener : this.listeners) {
            listener.treeRowModelChanged();
        }
    }

    public int depth(int index) {
        return this.treeData.getDepthOfData(this.treeData.getDataAtIndex(index));
    }

    public boolean isLeaf(int index) {
        return !this.hasChildren(index);
    }

    public boolean hasChildren(int index) {
        return this.treeData.hasChildren(this.treeData.getDataAtIndex(index));
    }

    public boolean isCollapsed(int index) {
        return !this.expandedIndexes.contains(index);
    }

    public void clear() {
        this.expandedIndexes.clear();
    }

    public boolean isCollapsible(int index) {
        return this.hasChildren(index);
    }

    public List<Integer> collapse(int index) {
        this.expandedIndexes.remove(index);
        this.notifyListeners();
        List<Integer> list = this.getChildIndexes((T)index);
        return list;
    }

    public List<Integer> expand(int index) {
        this.expandedIndexes.add(index);
        this.notifyListeners();
        List<Integer> children = this.getExpandedChildIndexes((T)index);
        return children;
    }

    public List<Integer> collapseAll() {
        return null;
    }

    public List<Integer> expandToLevel(int level) {
        return null;
    }

    public List<Integer> expandToLevel(T object, int level) {
        return null;
    }

    public List<Integer> expandAll() {
        return null;
    }

    public List<Integer> expandToLevel(int parentIndex, int level) {
        return null;
    }

    public List<T> getChildren(int parentIndex) {
        Object t = this.treeData.getDataAtIndex(parentIndex);
        return this.treeData.getChildren(t, true);
    }

    public List<T> getDirectChildren(int parentIndex) {
        return this.treeData.getChildren(parentIndex);
    }

    public List<Integer> collapse(T object) {
        int index = this.treeData.indexOf(object);
        return this.collapse((T)index);
    }

    public List<Integer> expand(T object) {
        int index = this.treeData.indexOf(object);
        return this.expand((T)index);
    }

    public boolean isCollapsed(T object) {
        int index = this.treeData.indexOf(object);
        return this.isCollapsed(index);
    }

    public List<Integer> getChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object t = this.treeData.getDataAtIndex(parentIndex);
        if (t == null) {
            return Collections.EMPTY_LIST;
        }
        List children = this.treeData.getChildren(t);
        for (Object child : children) {
            int index = this.treeData.indexOf(child);
            if (index >= 0) {
                result.add(index);
                result.addAll(this.getChildIndexes((T)index));
                continue;
            }
            result.addAll(this.getChildIndexes(child));
        }
        return result;
    }

    public List<Integer> getChildIndexes(T t) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List children = this.treeData.getChildren(t);
        for (Object child : children) {
            int index = this.treeData.indexOf(child);
            if (index >= 0) {
                result.add(index);
                result.addAll(this.getChildIndexes((T)index));
                continue;
            }
            result.addAll(this.getChildIndexes(child));
        }
        return result;
    }

    public List<Integer> getExpandedChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object t = this.treeData.getDataAtIndex(parentIndex);
        if (t == null) {
            return Collections.EMPTY_LIST;
        }
        List children = this.treeData.getChildren(t);
        for (Object child : children) {
            int index = this.treeData.indexOf(child);
            if (index >= 0) {
                result.add(index);
                if (!this.expandedIndexes.contains(index)) continue;
                result.addAll(this.getExpandedChildIndexes((T)index));
                continue;
            }
            result.addAll(this.getExpandedChildIndexes(child));
        }
        return result;
    }

    public List<Integer> getExpandedChildIndexes(T t) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List children = this.treeData.getChildren(t);
        for (Object child : children) {
            int index = this.treeData.indexOf(child);
            if (index >= 0) {
                result.add(index);
                if (!this.expandedIndexes.contains(index)) continue;
                result.addAll(this.getExpandedChildIndexes((T)index));
                continue;
            }
            result.addAll(this.getExpandedChildIndexes(child));
        }
        return result;
    }

    public List<Integer> getDirectChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        Object t = this.treeData.getDataAtIndex(parentIndex);
        if (t == null) {
            return Collections.emptyList();
        }
        List children = this.treeData.getChildren(t);
        for (Object child : children) {
            int index = this.treeData.indexOf(child);
            if (index < 0) continue;
            result.add(index);
        }
        return result;
    }

    public ITreeData<T> getTreeData() {
        return this.treeData;
    }
}

