/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.browsing.ui.model.dnd;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.model.nodetypes.NodeType;
import org.simantics.browsing.ui.model.nodetypes.NodeTypeMultiMap;
import org.simantics.browsing.ui.model.tests.Test;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.DropActionFactory;
import org.simantics.viewpoint.ontology.ViewpointResource;

public class DropActionContribution
implements Comparable<DropActionContribution> {
    NodeType nodeType;
    DropActionFactory actionFactory;
    Test test;
    double priority;

    public DropActionContribution(NodeType nodeType, DropActionFactory actionFactory, Test test, double priority) {
        this.nodeType = nodeType;
        this.actionFactory = actionFactory;
        this.test = test;
        this.priority = priority;
    }

    public static void load(ReadGraph g, Resource r, NodeTypeMultiMap<DropActionContribution> contributions) throws DatabaseException {
        ViewpointResource VR = ViewpointResource.getInstance((ReadGraph)g);
        NodeType nodeType = (NodeType)g.adapt(g.getSingleObject(r, VR.DropActionContribution_HasNodeType), NodeType.class);
        DropActionFactory actionFactory = (DropActionFactory)g.adapt(g.getSingleObject(r, VR.DropActionContribution_HasAction), DropActionFactory.class);
        Resource testResource = g.getPossibleObject(r, VR.DropActionContribution_HasCondition);
        Test test = testResource == null ? null : (Test)g.adapt(testResource, Test.class);
        Double mpriority = (Double)g.getPossibleRelatedValue(r, VR.DropActionContribution_HasPriority);
        double priority = mpriority == null ? 0.0 : mpriority;
        DropActionContribution contribution = new DropActionContribution(nodeType, actionFactory, test, priority);
        contributions.put(nodeType, contribution);
    }

    public Runnable getAction(ReadGraph graph, NodeContext context, Object source, int operation) {
        Object content = context.getConstant(BuiltinKeys.INPUT);
        try {
            if (this.test == null || this.test.test(graph, content)) {
                return this.actionFactory.create(graph, content, source, operation);
            }
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
        }
        return null;
    }

    @Override
    public int compareTo(DropActionContribution o) {
        return Double.compare(o.priority, this.priority);
    }
}

