package org.simantics.browsing.ui.graph.impl;

import org.simantics.browsing.ui.BuiltinKeys.ImageDecoratorKey;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.content.ImageDecorator;
import org.simantics.browsing.ui.graph.impl.contribution.ImageDecoratorContributionImpl;
import org.simantics.browsing.ui.model.browsecontexts.BrowseContext;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;

public class EvaluatorImageDecorator extends ImageDecoratorContributionImpl {

	final BrowseContext browseContext;
	final boolean useNodeBrowseContexts;
	
    public EvaluatorImageDecorator(PrimitiveQueryUpdater updater, NodeContext context, ImageDecoratorKey key,
    		BrowseContext browseContext, boolean useNodeBrowseContexts) {
		super(updater, context, key);
		this.browseContext = browseContext;
		this.useNodeBrowseContexts = useNodeBrowseContexts;
	}
    

	@Override
    public ImageDecorator getDecorator(ReadGraph graph, NodeContext context)
    throws DatabaseException {
        return BrowseContext.get(graph,context,browseContext,useNodeBrowseContexts).getImageDecorator(graph, context);
    }
};