/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.views;

import java.util.regex.Pattern;

import org.simantics.browsing.ui.common.processors.FilterSelectionRequestQueryProcessor;

/**
 * This is an interface for specifying a strategy for converting client-specified
 * search strings into regular expressions (see {@link Pattern}), that are used
 * to filter non-matches out of shown results.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see FilterSelectionRequestQueryProcessor
 * @see Pattern
 */
public interface IFilterStrategy {

    /**
     * @param filterText the client-specified filter text
     * @return a regular expression String adhering to the specifications of
     *         {@link Pattern} or <code>null</code> to denote <em>no filter</em>.
     */
    String toPatternString(String filterText);

}
