/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.property;

/**
 * @author Tuukka Lehtonen
 */
public interface PropertyComparable {

    /**
     * @return a hash code calculated from the data parts that identify the
     *         subject and the property, not the value of the property
     */
    int propertyHashCode();

    /**
     * Tells whether this property represents the exact same property of the
     * same subject, regardless of the value of the property.
     * 
     * @param o another object (property)
     * @return <code>true</code> if both represent the same property of the same
     *         subject
     */
    boolean propertyEquals(Object o);

}