/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;
import java.util.HashMap;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.SelectedViewpointFactoryKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.ViewpointFactory;
import org.simantics.utils.datastructures.Pair;

public class UserSelectedViewpointFactoryQueryProcessor extends AbstractPrimitiveQueryProcessor<ViewpointFactory> {

    HashMap<NodeContext, ViewpointFactory> selections = new HashMap<NodeContext, ViewpointFactory>();
    HashMap<NodeContext, Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>> updaters = new HashMap<NodeContext, Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>>();

    @Override
    public String toString() {
        return "UserSelectedViewpointFactoryProcessor";
    }

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.SelectedViewpointFactoryKey.class;
    }

    @Override
    public ViewpointFactory query(PrimitiveQueryUpdater updater, NodeContext context,
            PrimitiveQueryKey<ViewpointFactory> key) {

        updaters.put(context, new Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>(key, updater));
        ViewpointFactory result = selections.get(context);
        if (result != null)
            return result;

        SelectedViewpointFactoryKey k = (SelectedViewpointFactoryKey) key;
        Collection<ViewpointFactory> factories = k.getParameter(0);

        if (factories.isEmpty())
            return null;

        return factories.iterator().next();
    }

    public ViewpointFactory getSelection(NodeContext context) {
        return selections.get(context);
    }

    /**
     * Invoked by the user interfaces for selecting viewpoints.
     * 
     * @param context
     * @param factory
     */
    @SuppressWarnings("unchecked")
    public void select(NodeContext context, ViewpointFactory factory) {
        selections.put(context, factory);
        Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater> p = updaters.get(context);
        if (p.second == null)
            throw new IllegalArgumentException("context not found in cache");
        p.second.scheduleReplace(context, (PrimitiveQueryKey<ViewpointFactory>) p.first, factory);
    }

}
