/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.GraphExplorer;
import org.simantics.browsing.ui.PrimitiveQueryProcessor;

/**
 * An interface that {@link PrimitiveQueryProcessor} implementations may
 * implement in order to receive lifecycle-related notifications that can be
 * used e.g. for internal housekeeping.
 * 
 * @author Tuukka Lehtonen
 */
public interface ProcessorLifecycle {

    /**
     * This processor has been attached to the specified {@link GraphExplorer}
     * via {@link GraphExplorer#setPrimitiveProcessor(PrimitiveQueryProcessor)}
     * 
     * @param explorer the explorer to which this processor was just attached
     */
    void attached(GraphExplorer explorer);

    /**
     * This processor has been detached from the specified {@link GraphExplorer}
     * for one of these reasons:
     * <ul>
     * <li>replaced by another {@link PrimitiveQueryProcessor} through an
     * invocation to
     * {@link GraphExplorer#setPrimitiveProcessor(PrimitiveQueryProcessor)}</li>
     * <li>the graph explorer was disposed and all primitive processors are
     * being detached from it</li>
     * </ul>
     * 
     * @param explorer the explorer from which this processor was just detached
     */
    void detached(GraphExplorer explorer);

    /**
     * Invoked by GraphExplorer when its input is reset through
     * {@link GraphExplorer#setRoot(Object)}. Allows the processor to do
     * cleanup if necessary, e.g. for internal caches.
     */
    void clear();

}
