/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.ViewpointKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.Viewpoint;
import org.simantics.browsing.ui.content.ViewpointFactory;

public class DefaultViewpointProcessor extends AbstractPrimitiveQueryProcessor<Viewpoint> {

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.ViewpointKey.class;
    }

    @Override
    public String toString() {
        return "ViewpointProcessor";
    }

    @Override
    public Viewpoint query(PrimitiveQueryUpdater updater, NodeContext context, PrimitiveQueryKey<Viewpoint> key) {
        ViewpointKey k = (ViewpointKey) key;
        ViewpointFactory vf = k.getParameter(0);
        if (vf == null)
            return null;
        return vf.create(updater, context, k);
    }

}