/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.SelectionRequest;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.NodeContext.QueryKey;
import org.simantics.browsing.ui.content.PrunedChildrenResult;
import org.simantics.browsing.ui.content.ViewpointContribution;

public class DefaultPrunedChildrenProcessor extends AbstractNodeQueryProcessor<PrunedChildrenResult> {

    @Override
    public QueryKey<PrunedChildrenResult> getIdentifier() {
        return BuiltinKeys.PRUNED_CHILDREN;
    }

    @Override
    public PrunedChildrenResult query(NodeQueryManager manager, NodeContext context) {

        Collection<ViewpointContribution> contributions = manager.query(context, BuiltinKeys.VIEWPOINT_CONTRIBUTIONS);
        if (contributions == null)
            return PrunedChildrenResult.EMPTY;

        Set<NodeContext> childSet = new HashSet<NodeContext>();
        ArrayList<NodeContext> children = new ArrayList<NodeContext>();

        // Gather NodeContexts from all viewpoint contributions
        // into the 'children' result list to preserve the order.
        // 'childSet' is used to prevent duplicate contributions.
        for (ViewpointContribution contribution : contributions) {
            Class<?> clazz = contribution.getInputClass();
            if (clazz.isInstance(context.getConstant(BuiltinKeys.INPUT))) {
                Tester test = contribution.getNodeContextTester();
                if (test == null || test.test(manager, context)) {
                    Collection<NodeContext> contrib = contribution.getContribution();
                    children.ensureCapacity(children.size() + contrib.size());
                    for (NodeContext nc : contrib)
                        if (childSet.add(nc))
                            children.add(nc);
                }
            }
        }

//        Viewpoint viewpoint = manager.query(context, BuiltinKeys.SELECTED_VIEWPOINT);
//        if (viewpoint == null)
//            return PrunedChildrenResult.EMPTY;
//
//        INodeContext[] children = viewpoint.getChildren();

        Collection<SelectionRequest> selectionRequests = manager.query(context, BuiltinKeys.SELECTION_REQUESTS);
        if (selectionRequests == null)
            return new PrunedChildrenResult(children.size(), children.toArray(NodeContext.NONE));

        SelectionRequest[] reqs = selectionRequests.toArray(new SelectionRequest[selectionRequests.size()]);

        ArrayList<NodeContext> pruned = new ArrayList<NodeContext>();
        for (NodeContext ctx : children) {
            boolean add = true;

            if (selectionRequests != null) {
                for(SelectionRequest req : reqs) {
                    if (req.getRequest() == SelectionRequest.Request.FILTER) {
                        if (req.isIncluded(manager, ctx)) {
                            add = false;
                            break;
                        }
                    }
                }
            }

            if (add)
                pruned.add(ctx);
        }
        return new PrunedChildrenResult(children.size(), pruned.toArray(NodeContext.NONE));
    }

    @Override
    public String toString() {
        return "PrunedChildrenProcessor";
    }

}