/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.modifiers;

/**
 * A combination of an graph enumeration and one designated value of the
 * enumeration.
 * 
 * @author Tuukka Lehtonen
 * 
 * @param <T>
 */
public final class EnumerationValue<T> {

    private final Enumeration<T> enumeration;
    private final EnumeratedValue<T> enumeratedValue;

    public EnumerationValue(Enumeration<T> enumeration, EnumeratedValue<T> enumeratedValue) {
        this.enumeration = enumeration;
        this.enumeratedValue = enumeratedValue;
    }

    public Enumeration<T> getEnumeration() {
        return enumeration;
    }

    public EnumeratedValue<T> getEnumeratedValue() {
        return enumeratedValue;
    }

}
