/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.acorn;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.simantics.db.IO;

/**
 * @author Jani Simomaa
 */
public class RocksStore implements Store {

	private Path dbPath;
	private RocksDB db;

	public RocksStore(Path root) throws IOException {
		this.dbPath = root.resolve("rocks");
		try (Options options = new Options()) {
			options.setCreateIfMissing(true);
			this.db = RocksDB.open(options, dbPath.toAbsolutePath().toString());
		} catch (RocksDBException e) {
			throw new IOException(e);
		}
//		System.err.println("ROCKS INIT");
//		RocksIterator it = db.newIterator();
//		it.seekToFirst();
//		while(it.isValid()) {
//			String key = new String(it.key());
//			int len = it.value().length;
//			System.err.println(" -" + key + " " + len);
//			it.next();
//		}
	}
	
	public RocksDB db() {
		return db;
	}

	public IO getIO(AcornKey key) {
		return null;
	}

	@Override
	public void dispose() {
	}

	@Override
	public AcornKey rootKey(String name) {
		return new AcornKeyRocks(this, null, name);
	}

	@Override
	public Stream<AcornKey> directories() throws IOException {
		List<AcornKey> result = new ArrayList<>();
		RocksIterator it = db.newIterator();
		String prefix = "$";
		it.seek(prefix.getBytes());
		while(it.isValid()) {
			String key = new String(it.key());
			if(!key.startsWith(prefix))
				break;
			result.add(rootKey(key.substring(1)));
			it.next();
		}
		return result.stream();
	}

	@Override
	public void tryPurgeDirectory(AcornKey f, MainState mainState) {
		// TODO
	}

	@Override
	public void ensureExists() throws IOException {
		// NO NEED
	}

	@Override
	public String toString() {
		return "store:rocks:" + dbPath;
	}

}
