/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.acorn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import org.rocksdb.RocksDB;
import org.simantics.db.IO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Jani Simomaa
 */
public class RocksCache implements Cache {

	private static final Logger LOGGER = LoggerFactory.getLogger(RocksCache.class);
	
	private RocksDB db;
	private Map<AcornKey, RocksIO> map = new HashMap<>();

	public RocksCache(RocksDB db) throws IOException {
		this.db = db;
	}
	
	@Override
	public IO get(AcornKey path) {
		synchronized (map) {
			return map.computeIfAbsent(path, (key) -> {
				return new RocksIO(db, (AcornKeyRocks)path);
			});
		}
	}

	@Override
	public void dispose() {
		LOGGER.error("IMPL TODO");
	}
	
}
