/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RConnection;
import org.rosuda.REngine.Rserve.protocol.RPacket;

public class RserveException
extends REngineException {
    protected String err;
    protected int reqReturnCode;

    public String getRequestErrorDescription() {
        return this.getRequestErrorDescription(this.reqReturnCode);
    }

    public String getRequestErrorDescription(int code) {
        switch (code) {
            case 0: {
                return "no error";
            }
            case 2: {
                return "R parser: input incomplete";
            }
            case 3: {
                return "R parser: syntax error";
            }
            case 65: {
                return "authorization failed";
            }
            case 66: {
                return "connection broken";
            }
            case 67: {
                return "invalid command";
            }
            case 68: {
                return "invalid parameter";
            }
            case 70: {
                return "I/O error on the server";
            }
            case 71: {
                return "connection is not open";
            }
            case 72: {
                return "access denied (local to the server)";
            }
            case 73: {
                return "unsupported command";
            }
            case 74: {
                return "unknown command";
            }
            case 75: {
                return "data overflow, incoming data too big";
            }
            case 76: {
                return "evaluation successful, but returned object is too big to transport";
            }
            case 77: {
                return "FATAL: Rserve ran out of memory, closing connection";
            }
            case 80: {
                return "session is busy";
            }
            case 81: {
                return "session detach failed";
            }
            case 78: {
                return "control pipe to master process is closed/broken";
            }
        }
        return "error code: " + code;
    }

    @Override
    public String getMessage() {
        return super.getMessage() + (String)(this.reqReturnCode != -1 ? ", request status: " + this.getRequestErrorDescription() : "");
    }

    public RserveException(RConnection c, String msg) {
        this(c, msg, -1);
    }

    public RserveException(RConnection c, String msg, int requestReturnCode) {
        super(c, msg);
        this.reqReturnCode = requestReturnCode;
        if (c != null) {
            c.lastError = this.getMessage();
        }
    }

    public RserveException(RConnection c, String msg, RPacket p) {
        this(c, msg, p == null ? -1 : p.getStat());
    }

    public int getRequestReturnCode() {
        return this.reqReturnCode;
    }
}

