/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.OutputStream;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;

public class RFileOutputStream
extends OutputStream {
    RTalk rt;
    boolean closed;

    RFileOutputStream(RTalk rti, String fn) throws IOException {
        this.rt = rti;
        RPacket rp = this.rt.request(17, fn);
        if (rp == null || !rp.isOk()) {
            throw new IOException((String)(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat()));
        }
        this.closed = false;
    }

    @Override
    public void write(int b) throws IOException {
        byte[] ba = new byte[1];
        this.write(ba, 0, 1);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.closed) {
            throw new IOException("File is not open");
        }
        if (len < 0) {
            len = 0;
        }
        boolean isLarge = len > 0xFFFFF0;
        byte[] hdr = RTalk.newHdr(5, len);
        RPacket rp = this.rt.request(20, hdr, b, off, len);
        if (rp == null || !rp.isOk()) {
            throw new IOException((String)(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat()));
        }
    }

    @Override
    public void close() throws IOException {
        RPacket rp = this.rt.request(18, (byte[])null);
        if (rp == null || !rp.isOk()) {
            throw new IOException((String)(rp == null ? "Connection to Rserve failed" : "Request return code: " + rp.getStat()));
        }
        this.closed = true;
    }

    @Override
    public void flush() {
    }
}

