/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.test;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.utils.datastructures.BijectionMap;

public class GraphChanges {
    private Resource r1;
    private Resource r2;
    private List<Statement> deletions;
    private List<Statement> additions;
    private List<Modification> modifications;
    private BijectionMap<Resource, Resource> comparable;

    public GraphChanges(Resource r1, Resource r2, List<Statement> deletions, List<Statement> additions, List<Modification> modifications, BijectionMap<Resource, Resource> comparable) {
        this.r1 = r1;
        this.r2 = r2;
        this.deletions = deletions;
        this.additions = additions;
        this.modifications = modifications;
        this.comparable = comparable;
    }

    public Resource getResource1() {
        return this.r1;
    }

    public Resource getResource2() {
        return this.r2;
    }

    public List<Statement> getAdditions() {
        return this.additions;
    }

    public List<Statement> getDeletions() {
        return this.deletions;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public BijectionMap<Resource, Resource> getComparable() {
        return this.comparable;
    }

    public String toString(ReadGraph graph) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("Del:\n");
        for (Statement stm : this.deletions) {
            sb.append(GraphChanges.toString(graph, stm));
            sb.append("\n");
        }
        sb.append("Add:\n");
        for (Statement stm : this.additions) {
            sb.append(GraphChanges.toString(graph, stm));
            sb.append("\n");
        }
        sb.append("Mod:\n");
        for (Modification mod : this.modifications) {
            sb.append(GraphChanges.toString(graph, mod));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(ReadGraph graph, Statement stm) throws DatabaseException {
        return NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getSubject()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject()) + " (" + String.valueOf(stm.getSubject()) + " " + String.valueOf(stm.getPredicate()) + " " + String.valueOf(stm.getObject());
    }

    public static String toString(ReadGraph graph, Modification mod) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        Statement stm = mod.getLeftStm();
        if (stm != null) {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getLeftSub()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + GraphChanges.truncate(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject())) + " (" + String.valueOf(mod.getLeftSub()) + " " + String.valueOf(stm.getSubject()) + " " + String.valueOf(stm.getPredicate()) + " " + String.valueOf(stm.getObject()) + ")\n");
        } else {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getLeftSub()) + " " + String.valueOf(mod.getLeftSub()) + " N/A\n");
        }
        stm = mod.getRightStm();
        if (stm != null) {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getRightSub()) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getPredicate()) + " " + GraphChanges.truncate(NameUtils.getSafeName((ReadGraph)graph, (Resource)stm.getObject())) + " (" + String.valueOf(mod.getRightSub()) + " " + String.valueOf(stm.getSubject()) + " " + String.valueOf(stm.getPredicate()) + " " + String.valueOf(stm.getObject()) + ")");
        } else {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)mod.getRightSub()) + " " + String.valueOf(mod.getRightSub()) + " N/A");
        }
        return sb.toString();
    }

    public static String truncate(String s) {
        if (s.length() < 100) {
            return s;
        }
        return s.substring(0, 100) + "...";
    }

    public String comparableToString(ReadGraph graph) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        sb.append("Comparable:\n");
        for (Map.Entry entry : this.comparable.getEntries()) {
            sb.append(NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)entry.getKey())) + " " + NameUtils.getSafeName((ReadGraph)graph, (Resource)((Resource)entry.getValue())) + " (" + String.valueOf(entry.getKey()) + " " + String.valueOf(entry.getValue()) + ")\n");
        }
        return sb.toString();
    }

    public static GraphChanges adapt(Session session, final GraphChanges changes, final GraphChanges bijection) throws DatabaseException {
        if (!changes.getResource1().equals(bijection.getResource1())) {
            throw new DatabaseException("Left side model must be the same");
        }
        BijectionMap comparable = new BijectionMap();
        for (Map.Entry entry : changes.comparable.getEntries()) {
            if (((Resource)entry.getKey()).equals(entry.getValue())) {
                comparable.map((Object)((Resource)entry.getKey()), (Object)((Resource)entry.getValue()));
                continue;
            }
            Resource nl = (Resource)bijection.getComparable().getRight((Object)((Resource)entry.getKey()));
            if (nl == null) continue;
            comparable.map((Object)nl, (Object)((Resource)entry.getValue()));
        }
        final ArrayList<Statement> deletions = new ArrayList<Statement>(changes.getDeletions().size());
        ArrayList<Statement> additions = new ArrayList<Statement>(changes.getAdditions());
        session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                for (Statement del : changes.getDeletions()) {
                    Resource s1 = del.getSubject();
                    Resource s2 = (Resource)bijection.getComparable().getRight((Object)s1);
                    Resource p1 = del.getPredicate();
                    Resource p2 = (Resource)bijection.getComparable().getRight((Object)p1);
                    if (p2 == null) {
                        p2 = p1;
                    }
                    Resource o1 = del.getObject();
                    Resource o2 = (Resource)bijection.getComparable().getRight((Object)o1);
                    if (o2 == null) {
                        o2 = graph.getPossibleObject(s2, p2);
                    }
                    if (s2 == null || p2 == null || o2 == null) {
                        throw new DatabaseException("Did not find matching statement from bijection for (" + String.valueOf(s1) + "," + String.valueOf(p1) + "," + String.valueOf(o1) + "), got (" + String.valueOf(s2) + "," + String.valueOf(p2) + "," + String.valueOf(o2) + ")");
                    }
                    Statement stm2 = null;
                    for (Statement s : graph.getStatements(s2, p2)) {
                        if (!s.getObject().equals(o2)) continue;
                        stm2 = s;
                        break;
                    }
                    if (stm2 == null) {
                        throw new DatabaseException("Did not find matching statement from bijection for (" + String.valueOf(s1) + "," + String.valueOf(p1) + "," + String.valueOf(o1) + "), got (" + String.valueOf(s2) + "," + String.valueOf(p2) + "," + String.valueOf(o2) + "), but it is not in DB!");
                    }
                    deletions.add(stm2);
                }
            }
        });
        final ArrayList<Modification> modifications = new ArrayList<Modification>(changes.getModifications().size());
        session.syncRequest((Read)new ReadRequest(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run(ReadGraph graph) throws DatabaseException {
                for (Modification mod : changes.getModifications()) {
                    Statement del = mod.leftStm;
                    Resource sub1 = mod.getLeftSub();
                    Resource sub2 = (Resource)bijection.getComparable().getRight((Object)sub1);
                    Resource p1 = del != null ? del.getPredicate() : mod.getPredicate();
                    Resource p2 = (Resource)bijection.getComparable().getRight((Object)p1);
                    if (p2 == null) {
                        p2 = p1;
                    }
                    Resource o1 = del != null ? del.getObject() : null;
                    Resource o2 = (Resource)bijection.getComparable().getRight((Object)o1);
                    if (mod.isLeftAsserted() && sub2 == null) {
                        sub2 = sub1;
                    }
                    if (o2 == null && p2 != null) {
                        o2 = graph.getPossibleObject(sub2, p2);
                    }
                    if (mod.isLeftAsserted() && o2 == null) {
                        o2 = o1;
                    }
                    if (sub2 == null || p2 == null) {
                        throw new DatabaseException("Did not find matching statement from bijection for (" + String.valueOf(sub1) + "," + String.valueOf(p1) + "," + String.valueOf(o1) + "), got (" + String.valueOf(sub2) + "," + String.valueOf(p2) + "," + String.valueOf(o2) + ")");
                    }
                    if (del == null) {
                        Modification mod2 = new Modification(sub2, mod.rightSub, null, mod.rightStm);
                        modifications.add(mod2);
                        continue;
                    }
                    Collection stms = graph.getStatements(sub2, p2);
                    Statement stm2 = null;
                    if (o2 == null) {
                        if (stms.size() != 1) throw new DatabaseException("Did not find matching statement from bijection for (" + String.valueOf(sub1) + "," + String.valueOf(p1) + "," + String.valueOf(o1) + "), got (" + String.valueOf(sub2) + "," + String.valueOf(p2) + "," + String.valueOf(o2) + ")");
                        stm2 = (Statement)stms.iterator().next();
                    } else {
                        for (Statement s : stms) {
                            if (!s.getObject().equals(o2)) continue;
                            stm2 = s;
                            break;
                        }
                    }
                    if (stm2 == null) {
                        throw new DatabaseException("Did not find matching statement from bijection for (" + String.valueOf(sub1) + "," + String.valueOf(p1) + "," + String.valueOf(o1) + "), got (" + String.valueOf(sub2) + "," + String.valueOf(p2) + "," + String.valueOf(o2) + "), but it is not in DB!");
                    }
                    Modification mod2 = new Modification(sub2, mod.rightSub, stm2, mod.rightStm);
                    modifications.add(mod2);
                }
            }
        });
        return new GraphChanges(bijection.r2, changes.r2, deletions, additions, modifications, (BijectionMap<Resource, Resource>)comparable);
    }

    public static class Modification {
        Resource leftSub;
        Resource rightSub;
        Statement leftStm;
        Statement rightStm;
        int hashCode;

        public Modification(Resource leftSub, Resource rightSub, Statement leftStm, Statement rightStm) {
            this.leftSub = leftSub;
            this.rightSub = rightSub;
            this.leftStm = leftStm;
            this.rightStm = rightStm;
            this.hashCode = leftSub.hashCode() + rightSub.hashCode();
            if (leftStm != null) {
                this.hashCode += leftStm.hashCode();
            }
            if (rightStm != null) {
                this.hashCode += rightStm.hashCode();
            }
        }

        public boolean isLeftAsserted() {
            return this.leftStm != null && !this.leftSub.equals(this.leftStm.getSubject());
        }

        public boolean isRightAsserted() {
            return this.rightStm != null && !this.rightSub.equals(this.rightStm.getSubject());
        }

        public Resource getLeftSub() {
            return this.leftSub;
        }

        public void setLeftSub(Resource leftSub) {
            this.leftSub = leftSub;
        }

        public Resource getRightSub() {
            return this.rightSub;
        }

        public void setRightSub(Resource rightSub) {
            this.rightSub = rightSub;
        }

        public Statement getLeftStm() {
            return this.leftStm;
        }

        public void setLeftStm(Statement leftStm) {
            this.leftStm = leftStm;
        }

        public Statement getRightStm() {
            return this.rightStm;
        }

        public void setRightStm(Statement rightStm) {
            this.rightStm = rightStm;
        }

        public Resource getPredicate() {
            if (this.leftStm != null) {
                return this.leftStm.getPredicate();
            }
            return this.rightStm.getPredicate();
        }

        public boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Modification other = (Modification)obj;
            if (!this.leftSub.equals(other.leftSub)) {
                return false;
            }
            if (!this.rightSub.equals(other.rightSub)) {
                return false;
            }
            if (this.leftStm != null ? !this.leftStm.equals(other.leftStm) : other.leftStm != null) {
                return false;
            }
            return !(this.rightStm != null ? !this.rightStm.equals(other.rightStm) : other.rightStm != null);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

