/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.interop.xmlio;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.interop.xmlio.DependsOnSaveRule;
import org.simantics.interop.xmlio.SaveRule;
import org.simantics.layer0.DatabaseManagementResource;
import org.simantics.layer0.Layer0;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SaveXML
extends DefaultHandler
implements LexicalHandler {
    private Session session;
    private Resource root;
    private SaveRule saveRule;
    private File file;
    private PrintWriter fOut;
    protected boolean fCanonical = true;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11 = true;
    protected boolean fInCDATA;
    Map<Resource, Integer> idMap = new HashMap<Resource, Integer>();
    Set<Resource> processed = new HashSet<Resource>();
    Stack<Resource> stack = new Stack();
    Layer0 l0;
    int statements = 0;

    public SaveXML(Session session, Resource root, File file) {
        this.session = session;
        this.root = root;
        this.file = file;
        this.saveRule = new DependsOnSaveRule();
    }

    public void setSaveRule(SaveRule saveRule) {
        this.saveRule = saveRule;
    }

    public void save() throws DatabaseException, IOException, SAXException {
        this.fCanonical = false;
        FileOutputStream fos = new FileOutputStream(this.file);
        this.fOut = new PrintWriter(new OutputStreamWriter((OutputStream)fos, "UTF8"));
        this.startDocument();
        this.fXML11 = true;
        AttributesImpl attrs = new AttributesImpl();
        this.addDate(attrs);
        this.startElement("", "", "graphexport", attrs);
        this.saveGraphBundles();
        this.saveData();
        this.endElement("", "", "graphexport");
        this.endDocument();
        this.fOut.close();
    }

    private void addDate(AttributesImpl attrs) {
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int min = calendar.get(12);
        int sec = calendar.get(13);
        Object date = "";
        date = (String)date + year;
        date = (String)date + "-";
        if (month < 10) {
            date = (String)date + "0";
        }
        date = (String)date + month;
        date = (String)date + "-";
        if (day < 10) {
            date = (String)date + "0";
        }
        date = (String)date + day;
        date = (String)date + "T";
        if (hour < 10) {
            date = (String)date + "0";
        }
        date = (String)date + hour;
        date = (String)date + ":";
        if (min < 10) {
            date = (String)date + "0";
        }
        date = (String)date + min;
        date = (String)date + ":";
        if (sec < 10) {
            date = (String)date + "0";
        }
        date = (String)date + sec;
        attrs.addAttribute("", "", "date", "CDATA", (String)date);
    }

    private void saveData() throws DatabaseException {
        this.idMap.clear();
        this.processed.clear();
        this.stack.clear();
        this.statements = 0;
        this.session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                SaveXML.this.l0 = Layer0.getInstance((ReadGraph)graph);
                SaveXML.this.saveRule.init(graph);
                SaveXML.this.stack.push(SaveXML.this.root);
            }
        });
        try {
            while (!this.stack.isEmpty()) {
                this.session.syncRequest((Read)new ReadRequest(){

                    public void run(ReadGraph graph) throws DatabaseException {
                        try {
                            AttributesImpl attrs = new AttributesImpl();
                            while (!SaveXML.this.stack.isEmpty()) {
                                Resource r = SaveXML.this.stack.pop();
                                if (SaveXML.this.processed.contains(r)) continue;
                                SaveXML.this.processed.add(r);
                                Collection statement = graph.getStatements(r, SaveXML.this.l0.IsWeaklyRelatedTo);
                                boolean split = false;
                                for (Statement s : statement) {
                                    if (s.isAsserted(r) || !SaveXML.this.saveRule.save(graph, s)) continue;
                                    ++SaveXML.this.statements;
                                    int sId = SaveXML.this.getId(graph, s.getSubject(), false);
                                    int pId = SaveXML.this.getId(graph, s.getPredicate(), true);
                                    int oId = SaveXML.this.getId(graph, s.getObject(), false);
                                    attrs.clear();
                                    attrs.addAttribute("", "", "subject", "CDATA", Integer.toString(sId));
                                    attrs.addAttribute("", "", "predicate", "CDATA", Integer.toString(pId));
                                    attrs.addAttribute("", "", "object", "CDATA", Integer.toString(oId));
                                    SaveXML.this.startElement("", "", "statement", attrs);
                                    SaveXML.this.endElement("", "", "statement");
                                    if (!SaveXML.this.processed.contains(s.getObject())) {
                                        SaveXML.this.stack.push(s.getObject());
                                    }
                                    if (SaveXML.this.statements % 10000 != 0) continue;
                                    System.out.println("Processed " + SaveXML.this.statements + " statements...");
                                    split = true;
                                }
                                if (!split) continue;
                                return;
                            }
                            System.out.println("Done. Processed " + SaveXML.this.statements + " statements.");
                        }
                        catch (SAXException e) {
                            throw new DatabaseException((Throwable)e);
                        }
                    }
                });
            }
        }
        finally {
            this.idMap.clear();
            this.processed.clear();
            this.stack.clear();
        }
    }

    private int getId(ReadGraph g, Resource r, boolean rel) throws SAXException, DatabaseException {
        Integer id = this.idMap.get(r);
        if (id == null) {
            id = this.idMap.size();
            this.idMap.put(r, id);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "", "id", "CDATA", id.toString());
            if (rel) {
                attrs.addAttribute("", "", "rel", "CDATA", Boolean.TRUE.toString());
                String uri = g.getPossibleURI(r);
                if (uri != null) {
                    attrs.addAttribute("", "", "uri", "CDATA", uri);
                }
            }
            this.startElement("", "", "resource", attrs);
            if (!rel) {
                Layer0 l0 = Layer0.getInstance((ReadGraph)g);
                Collection types = g.getObjects(r, l0.InstanceOf);
                attrs.clear();
                for (Resource type : types) {
                    String uri = g.getPossibleURI(type);
                    if (uri != null) {
                        attrs.addAttribute("", "", "uri", "CDATA", uri);
                        this.startElement("", "", "type", attrs);
                        this.endElement("", "", "type");
                        continue;
                    }
                    throw new DatabaseException("Cannot resolve URI for type " + String.valueOf(type) + ", instance " + String.valueOf(r));
                }
            }
            if (g.hasValue(r)) {
                Object value = g.getValue(r);
                if (value instanceof Object[]) {
                    Object[] valuearray;
                    Object[] objectArray = valuearray = (Object[])value;
                    int n = valuearray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        attrs.clear();
                        attrs.addAttribute("", "", "value", "CDATA", o.toString());
                        this.startElement("", "", "value", attrs);
                        this.endElement("", "", "value");
                        ++n2;
                    }
                } else {
                    attrs.clear();
                    attrs.addAttribute("", "", "value", "CDATA", value.toString());
                    this.startElement("", "", "value", attrs);
                    this.endElement("", "", "value");
                }
            }
            this.endElement("", "", "resource");
        }
        return id;
    }

    private void saveGraphBundles() throws DatabaseException {
        final Resource rootLibrary = this.session.getRootLibrary();
        this.session.syncRequest((Read)new ReadRequest(){

            public void run(ReadGraph graph) throws DatabaseException {
                Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
                DatabaseManagementResource dm = DatabaseManagementResource.getInstance((ReadGraph)graph);
                Collection objs = graph.getObjects(rootLibrary, l0.ConsistsOf);
                Resource graphBundles = null;
                for (Resource o : objs) {
                    if (!SaveXML.this.isGraphBundleLib(graph, rootLibrary)) continue;
                    graphBundles = o;
                    break;
                }
                if (graphBundles == null) {
                    graphBundles = dm.InstalledGraphBundles;
                }
                objs = graph.getObjects(graphBundles, l0.ConsistsOf);
                AttributesImpl attrs = new AttributesImpl();
                try {
                    SaveXML.this.startElement("", "", "graphbundles", attrs);
                    for (Resource graphBundle : objs) {
                        if (!graph.isInstanceOf(graphBundle, dm.GraphBundle)) continue;
                        String name = (String)graph.getRelatedValue(graphBundle, l0.HasName);
                        String versionId = (String)graph.getRelatedValue(graphBundle, dm.HasVersionedId);
                        attrs.clear();
                        attrs.addAttribute("", "", "name", "CDATA", name);
                        attrs.addAttribute("", "", "versionid", "CDATA", versionId);
                        SaveXML.this.startElement("", "", "bundle", attrs);
                        SaveXML.this.endElement("", "", "bundle");
                    }
                    SaveXML.this.endElement("", "", "graphbundles");
                }
                catch (SAXException e) {
                    throw new DatabaseException((Throwable)e);
                }
            }
        });
    }

    private boolean isGraphBundleLib(ReadGraph graph, Resource o) throws DatabaseException {
        Layer0 l0 = Layer0.getInstance((ReadGraph)graph);
        String name = (String)graph.getPossibleRelatedValue(o, l0.HasName);
        return "InstalledGraphBundles".equals(name);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    @Override
    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(target);
            if (data != null && data.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(data);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    @Override
    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        if (this.fElementDepth == 0) {
            String encoding = "UTF-8";
            if (this.fLocator != null) {
                if (this.fLocator instanceof Locator2) {
                    Locator2 locator2 = (Locator2)this.fLocator;
                    this.fXML11 = "1.1".equals(locator2.getXMLVersion());
                    encoding = locator2.getEncoding();
                    if (encoding == null) {
                        encoding = "UTF-8";
                    }
                }
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                this.fOut.print("<?xml version=\"");
                this.fOut.print(this.fXML11 ? "1.1" : "1.0");
                this.fOut.print("\" encoding=\"");
                this.fOut.print(encoding);
                this.fOut.println("\"?>");
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(raw);
        if (attrs != null) {
            attrs = this.sortAttributes(attrs);
            int len = attrs.getLength();
            int i = 0;
            while (i < len) {
                this.fOut.print(' ');
                this.fOut.print(attrs.getQName(i));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attrs.getValue(i), true);
                this.fOut.print('\"');
                ++i;
            }
        }
        this.fOut.print(">\n");
        this.fOut.flush();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.fInCDATA) {
            this.normalizeAndPrint(ch, start, length, false);
        } else {
            int i = 0;
            while (i < length) {
                this.fOut.print(ch[start + i]);
                ++i;
            }
        }
        this.fOut.flush();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
        this.fOut.flush();
    }

    @Override
    public void endElement(String uri, String local, String raw) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(raw);
        this.fOut.print(">\n");
        this.fOut.flush();
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
        this.printError("Warning", ex);
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        this.printError("Error", ex);
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        this.printError("Fatal Error", ex);
        throw ex;
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            int i = 0;
            while (i < length) {
                this.fOut.print(ch[start + i]);
                ++i;
            }
            this.fOut.print("-->\n");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attrs) {
        return attrs;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char[] ch, int offset, int length, boolean isAttValue) {
        int i = 0;
        while (i < length) {
            this.normalizeAndPrint(ch[offset + i], isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String type, SAXParseException ex) {
        System.err.print("[");
        System.err.print(type);
        System.err.print("] ");
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            System.err.print(systemId);
        }
        System.err.print(':');
        System.err.print(ex.getLineNumber());
        System.err.print(':');
        System.err.print(ex.getColumnNumber());
        System.err.print(": ");
        System.err.print(ex.getMessage());
        System.err.println();
        System.err.flush();
    }
}

