/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.plant3d.scl;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.g3d.scenegraph.base.INode;
import org.simantics.objmap.graph.IMapping;
import org.simantics.objmap.graph.Mappings;
import org.simantics.objmap.graph.schema.IMappingSchema;
import org.simantics.plant3d.scenegraph.P3DRootNode;
import org.simantics.plant3d.scenegraph.SchemaBuilder;
import org.simantics.plant3d.scenegraph.controlpoint.ControlPointFactory;
import org.simantics.plant3d.scl.P3DScriptNodeMap;
import org.simantics.plant3d.utils.ComponentUtils;
import org.simantics.plant3d.utils.P3DUtil;
import org.simantics.scl.runtime.SCLContext;

public class SCLUtil {
    public static P3DScriptNodeMap load(Resource root) throws DatabaseException {
        return SCLUtil.load(SCLUtil.getRequestProcessor(), root);
    }

    public static P3DScriptNodeMap load(RequestProcessor session, Resource root) throws DatabaseException {
        SCLUtil.preload((RequestProcessor)Simantics.getSession(), "http://www.simantics.org/Plant3D-0.1/Builtin");
        SchemaProvider schemaProvider = g -> SchemaBuilder.getSchema(g);
        NodeMapProvider mapProvider = (mapping, rootNode) -> new P3DScriptNodeMap((RequestProcessor)Simantics.getSession(), mapping, rootNode);
        return SCLUtil.load(session, root, schemaProvider, mapProvider);
    }

    public static P3DRootNode loadReadOnly(Resource root) throws DatabaseException {
        return SCLUtil.loadReadOnly(SCLUtil.getRequestProcessor(), root);
    }

    public static P3DRootNode loadReadOnly(RequestProcessor session, Resource root) throws DatabaseException {
        SCLUtil.preload(session, "http://www.simantics.org/Plant3D-0.1/Builtin");
        SchemaProvider schemaProvider = g -> SchemaBuilder.getSchema(g);
        return SCLUtil.loadReadOnly(session, root, schemaProvider);
    }

    public static void preload(RequestProcessor session, String symbolSet) throws DatabaseException {
        try {
            ControlPointFactory.preloadCache(session, symbolSet);
            ComponentUtils.preloadCache(session);
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static <NodeMap extends P3DScriptNodeMap> NodeMap load(Resource root, SchemaProvider schemaProvider, NodeMapProvider mapProvider) throws DatabaseException {
        return SCLUtil.load(SCLUtil.getRequestProcessor(), root, schemaProvider, mapProvider);
    }

    public static <NodeMap extends P3DScriptNodeMap> NodeMap load(RequestProcessor session, final Resource root, final SchemaProvider schemaProvider, final NodeMapProvider mapProvider) throws DatabaseException {
        return (NodeMap)((Object)((P3DScriptNodeMap)((Object)session.syncRequest(new Read<NodeMap>(){

            public NodeMap perform(ReadGraph graph) throws DatabaseException {
                IMappingSchema<Resource, INode> schema = schemaProvider.get(graph);
                IMapping mapping = Mappings.createWithListening(schema);
                P3DRootNode rootNode = (P3DRootNode)((Object)mapping.map(graph, (Object)root));
                rootNode.setMapping((IMapping<Resource, INode>)mapping);
                try {
                    P3DUtil.finalizeDBLoad(rootNode);
                    P3DUtil.finalizeDBLoad2(rootNode);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
                P3DScriptNodeMap nodeMap = mapProvider.get((IMapping<Resource, INode>)mapping, rootNode);
                return (Object)nodeMap;
            }
        }))));
    }

    public static <Root extends P3DRootNode> Root loadReadOnly(RequestProcessor session, final Resource root, final SchemaProvider schemaProvider) throws DatabaseException {
        return (Root)((Object)((P3DRootNode)((Object)session.syncRequest(new Read<Root>(){

            public Root perform(ReadGraph graph) throws DatabaseException {
                IMappingSchema<Resource, INode> schema = schemaProvider.get(graph);
                IMapping mapping = Mappings.createWithoutListening(schema);
                P3DRootNode rootNode = (P3DRootNode)((Object)mapping.map(graph, (Object)root));
                rootNode.setMapping((IMapping<Resource, INode>)mapping);
                try {
                    P3DUtil.finalizeDBLoad(rootNode);
                    P3DUtil.finalizeDBLoad2(rootNode);
                }
                catch (Exception e) {
                    throw new DatabaseException((Throwable)e);
                }
                return (Object)rootNode;
            }
        }))));
    }

    public static <Root extends P3DRootNode> Root loadReadOnly(Resource root, SchemaProvider schemaProvider) throws DatabaseException {
        return SCLUtil.loadReadOnly(SCLUtil.getRequestProcessor(), root, schemaProvider);
    }

    public static RequestProcessor getRequestProcessor() {
        RequestProcessor rp = (RequestProcessor)SCLContext.getCurrent().get((Object)"graph");
        return rp != null ? rp : Simantics.getSession();
    }

    public static interface NodeMapProvider {
        public P3DScriptNodeMap get(IMapping<Resource, INode> var1, P3DRootNode var2);
    }

    public static interface SchemaProvider {
        public IMappingSchema<Resource, INode> get(ReadGraph var1) throws DatabaseException;
    }
}

